<?php
ini_set('display_errors','Off');
require_once __DIR__ . '/../models/auth/Token.php';
require_once __DIR__ . '/../models/sistema/Usuario.php';
require_once __DIR__ . '/../models/sistema/Historial.php';
require_once __DIR__ . '/../models/sistema/Tokens.php';
require_once __DIR__ . '/../models/sistema/Menu.php';
require_once __DIR__ . '/../models/sistema/MenuInfoUsuario.php';
require_once __DIR__ . '/../models/usuario/PerfilInfoUsuario.php';
require_once __DIR__ . '/../models/usuario/ActualizaDatosPerfil.php';
require_once __DIR__ . '/../models/usuario/GuardarFotoPerfil.php';
require_once __DIR__ . '/../models/eventos/eventos.php';
require_once __DIR__ . '/../models/productoras/productoras.php';
require_once __DIR__ . '/../models/eventos/galeriaEvento.php';
require_once __DIR__ . '/../models/tienda/carroCompra.php';
require_once __DIR__ . '/../models/usuario/usuarioPortal.php';
require_once __DIR__ . '/../models/eventos/EventosUsuario.php';
require_once __DIR__ . '/../models/eventos/EntradasEventoModel.php';
require_once __DIR__ . '/../models/eventos/ConsumoEvento.php';
require_once __DIR__ . '/../models/eventos/EventoModel.php';
require_once __DIR__ . '/../models/productoras/DatosTributariosProductora.php';
require_once __DIR__ . '/../models/finanzas/DteModel.php';
require_once __DIR__ . '/../models/finanzas/RetirosAnticipados.php';
require_once __DIR__ . '/../models/usuario/UsuarioContactoEmergencia.php';
require_once __DIR__ . '/../models/usuario/BotonPanico.php';
require_once __DIR__ . '/../models/ventas/VentaDocumentosPdf.php';
require_once __DIR__ . '/../models/ventas/VentaProceso.php';
require_once __DIR__ . '/../models/ventas/VentaProcesoMercadoPago.php';
require_once __DIR__ . "/../models/eventos/EventoGestion.php";
require_once __DIR__ . "/../models/finanzas/CuponDescuentoModel.php";
require_once __DIR__ . "/../models/reportes/ReportesModel.php";
require_once __DIR__ . "/../models/ticketPesos/ticketPesos.php";
require_once __DIR__ . '/../models/productoras/perfilesProductora.php';
require_once __DIR__ . '/../models/finanzas/VentaFinanzasProductora.php';
require_once __DIR__ . '/../models/usuario/PreferenciasUsuario.php';
require_once __DIR__ . '/../models/usuario/PermisosPerfil.php';
require_once __DIR__ . '/../models/whatsapp/WhatsappMyTapy.php';
require_once __DIR__ . '/../models/productoras/SolicitudTicketFisicoModel.php';
require_once __DIR__ . '/../models/direcciones/Direcciones.php';




class AuthController {
    
     private const PDF_BASE_DIR = '/home/aigc/api.ticketiza.cl/public/pdfs/';
    private const PDF_BASE_URL = 'https://api.ticketiza.cl/public/pdfs/';
 
    private function getAuthorizationHeader()
    {
        $headers = [];
        if (function_exists('apache_request_headers')) {
            $headers = apache_request_headers();
        } else {
            foreach ($_SERVER as $key => $value) {
                if (substr($key, 0, 5) == "HTTP_") {
                    $header = str_replace(" ", "-", ucwords(str_replace("_", " ", strtolower(substr($key, 5)))));
                    $headers[$header] = $value;
                }
            }
        }
        return $headers;
    }
      
    public function validateToken()
    {
        $headers = $this->getAuthorizationHeader();
       # print_r($headers);
        $token = isset($headers["Authorization"]) ? trim($headers["Authorization"]) : null;
        if (!$token) {
            http_response_code(401);
            echo json_encode(["error" => "Token no proporcionado"]);
            exit();
        }
        $tokenModel = new Token();
        if (!$tokenModel->exists($token)) {
            http_response_code(403);
            echo json_encode(["error" => "Token inválido"]);
            exit();
        }
    }
     
    public function iniciarSesion()
    {
        $this->validateToken();

        
        $data = json_decode(file_get_contents("php://input"), true);
        if (!isset($data['usuario']) || !isset($data['password'])) {
            http_response_code(400);
            echo json_encode(["error" => "Parámetros 'usuario' y 'password' son requeridos"]);
            exit();
        }
        $usuario_param = $data['usuario'];
        $password_param = $data['password'];

        
        $usuarioModel = new Usuario();
        $userData = $usuarioModel->authenticate($usuario_param, $password_param);

            if (!$userData['success']) {
                http_response_code(401);
                echo json_encode([
                    "success" => false,
                    "error"   => $userData['error'],
                    "message" => $userData['message']
                ]);
                exit();
            }
            
            echo json_encode([
                "success" => true,
                "message" => "Inicio de sesión exitoso",
                "user"    => $userData['user']
            ]);

    } 
      
      
    

      
    public function perfilInfoUsuarios()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
        
        if (!isset($data['IdUsuario'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'IdUsuario' es requerido"
            ]);
            exit();
        }
    
        $idUsuario = $data['IdUsuario'];
    
        $init = new PerfilInfoUsuario();
        $mensaje = $init->PerfilDatosUsuario($idUsuario);
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }     
 
 
 
    public function obtenerPreferenciasUsuario() {
    
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!isset($data['IdUsuario'], $data['tipo'])) {
            http_response_code(400);
            echo json_encode([
                'status' => 'error',
                'message' => 'Parámetros incompletos'
            ]);
            return;
        }
    
        // 👇 MODELO CORRECTO
        $model = new PreferenciasUsuario();
    
        $preferencias = $model->obtenerPreferenciasUsuario(
            $data['IdUsuario'],
            $data['tipo']
        );
    
        echo json_encode([
            'status'  => 'ok',
            'message' => $preferencias
        ]);
    }
    
    public function obtenerPreferenciasProductora() {

        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!isset($data['idProductora'])) {
            http_response_code(400);
            echo json_encode([
                'status'  => 'error',
                'message' => 'Parámetros incompletos'
            ]);
            return;
        }
    
        $model = new PreferenciasUsuario();
    
        $preferencias = $model->obtenerPreferenciasProductora(
            (int) $data['idProductora']
        );
    
        echo json_encode([
            'status'  => 'ok',
            'message' => $preferencias
        ]);
    }


    
    public function actualizarPreferencia() {
    
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!isset($data['IdUsuario'], $data['IdPreferencia'], $data['Valor'])) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Faltan parámetros'
            ]);
            return;
        }
    
        $model = new PreferenciasUsuario();
    
        $ok = $model->actualizarPreferenciaUsuario(
            $data['IdUsuario'],
            $data['IdPreferencia'],
            $data['Valor']
        );
    
        echo json_encode([
            'status' => $ok ? 'ok' : 'error'
        ]);
    }
    
    public function actualizarPreferenciaProductora() {

        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!isset($data['idProductora'], $data['clave'], $data['estado'])) {
            http_response_code(400);
            echo json_encode([
                'status'  => 'error',
                'message' => 'Parámetros incompletos'
            ]);
            return;
        }
    
        if (!in_array($data['estado'], ['activado', 'desactivado'])) {
            http_response_code(400);
            echo json_encode([
                'status'  => 'error',
                'message' => 'Estado inválido'
            ]);
            return;
        }
    
        $model = new PreferenciasUsuario();
    
        $ok = $model->actualizarPreferenciaProductora(
            (int) $data['idProductora'],
            $data['clave'],
            $data['estado']
        );
    
        echo json_encode([
            'status' => $ok ? 'ok' : 'error'
        ]);
    }

    public function obtenerPerfilesPermisos()
    {
        $this->validateToken();
    
        try {
            $model = new PermisosPerfil();
    
            $data = $model->obtenerPerfilesConPermisos();
    
            echo json_encode([
                'status'  => 'ok',
                'message' => $data
            ]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'status'  => 'error',
                'message' => 'No se pudieron obtener los permisos por perfil'
            ]);
        }
    }

    public function menu()
    {
            // Valida el token (como ya lo haces)
            $this->validateToken();
        
            // Lee el body JSON para obtener idUser
            $raw  = file_get_contents('php://input');
            $body = json_decode($raw, true) ?: [];
            $idUser = isset($body['idUser']) ? (int)$body['idUser'] : 0;
        
            $init = new Menu();
        
            if ($idUser > 0) {
                // Menú filtrado por usuario (JOIN usuarios/perfiles)
                $mensaje = $init->MenuConstructorPorUsuario($idUser);
            } else {
                // Fallback: menú completo
                $mensaje = $init->MenuConstructor();
            }
        
            if (empty($mensaje)) {
                echo json_encode([
                    "message" => 'Menú vacío o error de perfil/usuario.',
                    "status"  => 'error'
                ], JSON_UNESCAPED_UNICODE);
                return;
            }
        
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ], JSON_UNESCAPED_UNICODE);
        }
      
    public function menuInfoUsuarios()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
        
        if (!isset($data['IdUsuario'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'IdUsuario' es requerido"
            ]);
            exit();
        }
    
        $idUsuario = $data['IdUsuario'];
    
        $init = new MenuInfoUsuario();
        $mensaje = $init->MenuDatosUsuario($idUsuario);
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
    
    
    public function perfilesProductora()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
        
          
        $init = new perfilesProductoras();
        $mensaje = $init->perfiles();
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
    
    
    public function invitacionUsuarioProductora()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
        
        if (!isset($data['idProductora'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'idProductora' es requerido"
            ]);
            exit();
        }
     
        if (!isset($data['correo'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'correo' es requerido"
            ]);
            exit();
        }
        
        if (!isset($data['idUsuarioSuperior'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'idUsuarioSuperior' es requerido"
            ]);
            exit();
        }
        if (!isset($data['perfil'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'perfil' es requerido"
            ]);
            exit();
        }
     
        $idProductora  = $data['idProductora'];
        $correo     = $data['correo'];
        $idUsuarioSuperior   = $data['idUsuarioSuperior'];
        $perfil   = $data['perfil'];
          
        $init = new perfilesProductoras();
        $mensaje = $init->invitacion($correo,$idProductora,$idUsuarioSuperior,$perfil);
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
    
    public function cortesiaEntradasEvento()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!isset($data['idProductora'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'idProductora' es requerido"
            ]);
            exit();
        }
    
        if (!isset($data['idEvento'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'idEvento' es requerido"
            ]);
            exit();
        }
    
        if (!isset($data['correo'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'correo' es requerido"
            ]);
            exit();
        }
    
        if (!isset($data['idUsuarioSuperior'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'idUsuarioSuperior' es requerido"
            ]);
            exit();
        }
    
        if (!isset($data['cantidadCortesias'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'cantidadCortesias' es requerido"
            ]);
            exit();
        }
    
        if (!isset($data['item'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'item' es requerido"
            ]);
            exit();
        }

        $idProductora      = (int)$data['idProductora'];
        $idEvento          = (int)$data['idEvento'];
        $correo            = $data['correo'];
        $idUsuarioSuperior = (int)$data['idUsuarioSuperior'];
        $cantidadCortesias = (int)$data['cantidadCortesias'];
        $item              = $data['item']; 
    
        $init = new perfilesProductoras();
        $mensaje = $init->generarCortesiasEvento(
            $correo,
            $idProductora,
            $idEvento,
            $idUsuarioSuperior,
            $cantidadCortesias,
            $item           
        );
    
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }

    
    
    public function ActualizaDatosUsuarioPerfil()
    {
        
        
         // Primero valida el token
        $this->validateToken();
    
        // Recoge los parámetros enviados en JSON
        $data = json_decode(file_get_contents("php://input"), true);
        
        if (!isset($data['IdUsuario'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'IdUsuario' es requerido"
            ]);
            exit();
        }
     
    
        if (!isset($data['Nombre'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'Nombre' es requerido"
            ]);
            exit();
        }
        if (!isset($data['Apellido'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'Apellido' es requerido"
            ]);
            exit();
        }
        if (!isset($data['Correo'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'Correo' es requerido"
            ]);
            exit();
        }
        if (!isset($data['Telefono'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'Telefono' es requerido"
            ]);
            exit();
        }
        
        if (!isset($data['FechaNac'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "El parámetro 'FechaNac' es requerido"
            ]);
            exit();
        }
        
        $IdUsuario  = $data['IdUsuario'];
        $Nombre     = $data['Nombre'];
        $Apellido   = $data['Apellido'];
        $Correo     = $data['Correo'];
        $Telefono   = $data['Telefono'];
        $FechaNac   = $data['FechaNac'];
        
        
         $init = new ActualizaDatosUsuarioPerfil(); 
         $mensaje = $init->ActualizaDatosPerfil($IdUsuario,$Nombre,$Apellido,$Correo,$Telefono,$FechaNac);
         
         
         if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
          
    public function SubFotoUsuarioPerfil()
    {
        // Primero valida el token
        $this->validateToken();
    
        // Validación de parámetros requeridos
        if (!isset($_POST['IdUsuario']) || !isset($_FILES['foto'])) {
            http_response_code(400);
            echo json_encode([
                "error" => "Se requieren los parámetros 'IdUsuario' y 'foto'."
            ]);
            exit();
        }
    
        $IdUsuario = $_POST['IdUsuario'];
        $foto = $_FILES['foto'];
    
        // Validación del archivo
        if ($foto['error'] !== UPLOAD_ERR_OK) {
            http_response_code(400);
            echo json_encode([
                "error" => "Error al subir la imagen."
            ]);
            exit();
        }
    
        // Opcional: Validar tipo de archivo
        $tiposPermitidos = ['image/jpeg', 'image/png', 'image/webp'];
        if (!in_array($foto['type'], $tiposPermitidos)) {
            http_response_code(415);
            echo json_encode([
                "error" => "Tipo de archivo no permitido. Usa JPG, PNG o WEBP."
            ]);
            exit();
        }
    
        // Enviar a la clase encargada de procesarla
        $init = new guardarPortadaUsuarioPerfil();
        $mensaje = $init->GuardarFotoPerfil($IdUsuario, $foto);
    
        if (!$mensaje) {
            echo json_encode([
                "message" => "Error al guardar la imagen.",
                "status"  => "error"
            ]);
        } else {
            echo json_encode([
                "message" => "Imagen actualizada correctamente",
                "url_publica" =>$mensaje,
                "status"  => "ok"
            ]);
        }
    }
 
    public function listaEvento()
    {
        $this->validateToken();
    
        // Tomamos filtros desde GET o desde POST (JSON). GET tiene prioridad si trae el campo.
        $body = json_decode(file_get_contents('php://input'), true) ?? [];
    
        $filters = [
            'idEvento'       => $_GET['idEvento']       ?? ($body['idEvento']      ?? null), 
            'comuna'         => $_GET['comuna']         ?? $body['comuna']         ?? null,
            'region'         => $_GET['region']         ?? $body['region']         ?? null,
            'categoria'      => $_GET['categoria']      ?? $body['categoria']      ?? null, // por nombre
            'productora'     => $_GET['productora']     ?? $body['productora']     ?? null, // por nombre
        ];
    
        // Limpieza básica (strings vacíos -> null)
        foreach ($filters as $k => $v) {
            if ($v === '' || $v === 'null') { $filters[$k] = null; }
        }
    
        $init = new Evento();
        $mensaje = $init->datosEvento($filters);
    
        if ($mensaje === false) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status" => 'error'
            ]);
            return;
        }
    
        echo json_encode([
            "message" => $mensaje,
            "status" => 'ok'
        ]);
    }
    
    public function listaProductoras()
    {
        $this->validateToken();
    
        $init = new Evento();
        $mensaje = $init->listaProductorasActivas();
    
        if ($mensaje === false) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
            return;
        }
    
        echo json_encode([
            "message" => $mensaje,
            "status"  => 'ok'
        ]);
    }

  
    public function datosEventoCompleto()
    {
        $this->validateToken();
    
        $body = json_decode(file_get_contents('php://input'), true) ?? [];
        $idEvento = $_GET['idEvento'] ?? ($body['idEvento'] ?? null);
        $idEvento = ($idEvento !== null && $idEvento !== '' && $idEvento !== 'null') ? (int)$idEvento : null;
    
        $init = new Evento();
        $mensaje = $init->datosEventoCompleto($idEvento);
    
        if ($mensaje === false) {
            echo json_encode(["message" => 'Hay un error en el sistema', "status" => 'error']);
            return;
        }
        echo json_encode(["message" => $mensaje, "status" => 'ok']);
    }
    
    public function actualizarEventoCompleto()
    {
        $this->validateToken();
    
        $body = json_decode(file_get_contents('php://input'), true) ?? [];
    
        if (empty($body['idEvento'])) {
            echo json_encode([
                "status" => "error",
                "message" => "Falta idEvento"
            ]);
            return;
        }
    
        $idEvento = (int)$body['idEvento'];
    
        $model = new Evento();
        $resp = $model->actualizarEventoCompleto($idEvento, $body);
    
        echo json_encode(["message" => $resp, "status" => $resp['status']]);
    }
    
    public function duplicarEvento()
    {
        $this->validateToken();
    
        $body = json_decode(file_get_contents("php://input"), true);
    
        if (empty($body['idEvento'])) {
            echo json_encode(["status" => "error", "message" => "Falta idEvento"]);
            return;
        }
    
        $idEvento = (int)$body['idEvento'];
    
        $model = new Evento();
        $resp = $model->duplicarEvento($idEvento);
    
        echo json_encode($resp);
    }
    
    public function inactivarEvento()
    {
        $this->validateToken();
    
        $body = json_decode(file_get_contents("php://input"), true);
    
        if (empty($body['idEvento'])) {
            echo json_encode(["status" => "error", "message" => "Falta idEvento"]);
            return;
        }
    
        $idEvento = (int)$body['idEvento'];
    
        $model = new Evento();
        $resp = $model->inactivarEvento($idEvento);
    
        echo json_encode($resp);
    }

    public function datosEventosDashboard()
    {
        $this->validateToken();
    
        $init = new Evento();
        $mensaje = $init->datosEventosDashboard();
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
  
    public function categoriaEvento()
    {
        $this->validateToken();
    
        $init = new Evento();
        $mensaje = $init->categoriaEvento();
        
        if (!$mensaje) {
            echo json_encode([
                "message" => 'Hay un error en el sistema',
                "status"  => 'error'
            ]);
        } else {
            echo json_encode([
                "message" => $mensaje,
                "status"  => 'ok'
            ]);
        }
    }
 
    public function EntradasEvento()
    {
    // Primero valida el token
    $this->validateToken();

    // Recoge los parámetros enviados en JSON
    $data = json_decode(file_get_contents("php://input"), true);
    
    if (!isset($data['idEvento'])) {
        http_response_code(400);
        echo json_encode([
            "error" => "El parámetro 'idEvento' es requerido"
        ]);
        exit();
    }
 
    $idEvento = $data['idEvento'];

    $init = new Evento();
    $mensaje = $init->EntradasEvento($idEvento);
    
    if (!$mensaje) {
        echo json_encode([
            "message" => 'Hay un error en el sistema',
            "status"  => 'error'
        ]);
    } else {
        echo json_encode([
            "message" => $mensaje,
            "status"  => 'ok'
        ]);
    }
} 

    public function solicitarTicketFisico()
    {
        // Auth estándar
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        // Validación de parámetros
        if (
            empty($data['idProductora']) ||
            empty($data['idEvento']) ||
            empty($data['tipoTicket']) ||
            empty($data['cantidad'])
        ) {
            http_response_code(400);
            echo json_encode([
                'status'  => 'error',
                'message' => 'Parámetros incompletos'
            ]);
            return;
        }
    
        $idProductora = (int) $data['idProductora'];
        $idEvento     = (int) $data['idEvento'];
        $tipoTicket   = trim($data['tipoTicket']);
        $cantidad     = (int) $data['cantidad'];
    
        // Modelo
        $model = new SolicitudTicketFisicoModel();
    
        // 1️⃣ Insertar solicitud
        $ok = $model->crearSolicitud(
            $idProductora,
            $idEvento,
            $tipoTicket,
            $cantidad
        );
    
        if (!$ok) {
            http_response_code(500);
            echo json_encode([
                'status'  => 'error',
                'message' => 'No se pudo crear la solicitud'
            ]);
            return;
        }
    
        // 2️⃣ Obtener datos para correo
        $detalle = $model->obtenerDetalleSolicitud(
            $idProductora,
            $idEvento
        );
    
        // Fallback seguro
        $nombreProductora = $detalle['nombreProductora'] ?? 'Productora desconocida';
        $tituloEvento     = $detalle['tituloEvento'] ?? 'Evento desconocido';
        $diaEvento        = $detalle['diaEvento'] ?? '';
        $horaEvento       = $detalle['HorainicioEvento'] ?? '';
    
        // 3️⃣ Armar correo
        $asunto = 'Solicitud de tickets físicos';
    
        $mensajeHtml = "
            <h3>Solicitud de Tickets Físicos</h3>
            <p><strong>Productora:</strong> {$nombreProductora}</p>
            <p><strong>Evento:</strong> {$tituloEvento}</p>
            <p><strong>Fecha evento:</strong> {$diaEvento} {$horaEvento}</p>
            <p><strong>Tipo de ticket:</strong> {$tipoTicket}</p>
            <p><strong>Cantidad solicitada:</strong> {$cantidad}</p>
            <hr>
            <p>Solicitud generada desde el panel de productora.</p>
        ";
    
        // 4️⃣ Enviar correo (motor existente)
        $this->enviarCorreoInterno(
            $asunto,
            $mensajeHtml,
            ['app@ticketiza.cl']
        );
    
        // 5️⃣ Respuesta OK
        echo json_encode([
            'status'  => 'ok',
            'message' => 'Solicitud enviada correctamente'
        ]);
    }
    
    public function obtenerTiposTicketEvento()
        {
            $this->validateToken();
        
            $data = json_decode(file_get_contents("php://input"), true);
        
            if (empty($data['idEvento'])) {
                http_response_code(400);
                echo json_encode([
                    'status'  => 'error',
                    'message' => 'idEvento requerido'
                ]);
                return;
            }
        
            $idEvento = (int) $data['idEvento'];
        
            $model = new SolicitudTicketFisicoModel();
        
            $tipos = $model->obtenerTiposTicketPorEvento($idEvento);
        
            echo json_encode([
                'status' => 'ok',
                'data'   => $tipos
            ]);
        }



public function listaEquipoProductora()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            'status'  => 'error',
            'message' => "El parámetro 'idProductora' es requerido"
        ]);
        exit;
    }

    $idProductora = (int)$data['idProductora'];

    $init = new perfilesProductoras();
    $lista = $init->datosProductoraUsuario($idProductora);

    echo json_encode([
        'status' => 'ok',
        'data'   => $lista
    ], JSON_UNESCAPED_UNICODE);
}

public function gestionarAccesoProductora()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora']) || empty($data['idUsuario']) || empty($data['accion'])) {
        http_response_code(400);
        echo json_encode([
            'status'  => 'error',
            'message' => "Faltan parámetros: idProductora, idUsuario o accion"
        ]);
        exit;
    }

    $idProductora = (int)$data['idProductora'];
    $idUsuario    = (int)$data['idUsuario'];
    $accion       = strtolower(trim($data['accion']));
    $perfil       = isset($data['perfil']) ? (int)$data['perfil'] : null;

    $init = new Productora();
    $resp = $init->gestionarAccesoProductora($idProductora, $idUsuario, $accion, $perfil);

    echo json_encode($resp, JSON_UNESCAPED_UNICODE);
}



  
 public function datosProductoraUsuarios()
    {
    $this->validateToken();
 
    $data = json_decode(file_get_contents("php://input"), true);
    
    if (!isset($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "error" => "El parámetro 'idProductora' es requerido"
        ]);
        exit();
    }

    $idProductora = $data['idProductora'];

    $init = new Productora();
    $mensaje = $init->datosProductoraUsuario($idProductora);
    
    if (!$mensaje) {
        echo json_encode([
            "message" => 'Hay un error en el sistema',
            "status"  => 'error'
        ]);
    } else {
        echo json_encode([
            "message" => $mensaje,
            "status"  => 'ok'
        ]);
    }
}
 
    public function datosProductora()
    {
    $this->validateToken();

    // Recoge los parámetros enviados en JSON
    $data = json_decode(file_get_contents("php://input"), true);
    
    if (!isset($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "error" => "El parámetro 'idProductora' es requerido"
        ]);
        exit();
    }

    $idProductora = $data['idProductora'];

    $init = new Productora();
    $mensaje = $init->datosProductora($idProductora);
    
    if (!$mensaje) {
        echo json_encode([
            "message" => 'Hay un error en el sistema',
            "status"  => 'error'
        ]);
    } else {
        echo json_encode([
            "message" => $mensaje,
            "status"  => 'ok'
        ]);
    }
}

    public function actualizarDatosProductora()
    {
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
        if (!is_array($data)) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"JSON inválido"]);
            exit();
        }
    
        if (empty($data['idProductora'])) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"idProductora es requerido"]);
            exit();
        }
    
        $idProductora = (int)$data['idProductora'];
    
        // Campos permitidos (whitelist)
        $update = [
            'razonSocial' => trim((string)($data['razonSocial'] ?? '')),
            'rut'         => trim((string)($data['rut'] ?? '')),
            'direccion'   => trim((string)($data['direccion'] ?? '')),
            'giro'        => trim((string)($data['giro'] ?? '')),
            'correoDte'   => trim((string)($data['correoDte'] ?? '')),
            'telefono'    => trim((string)($data['telefono'] ?? '')),
        ];
    
        // Validación mínima
        if ($update['razonSocial'] === '' || $update['rut'] === '') {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"razonSocial y rut son obligatorios"]);
            exit();
        }
    
        $init = new Productora();
        $ok = $init->actualizarDatosTributariosProductora($idProductora, $update);
    
        if (!$ok) {
            echo json_encode(["status"=>"error","message"=>"No se pudo actualizar"]);
        } else {
            echo json_encode(["status"=>"ok","message"=>"Actualizado"]);
        }
    }

    public function subirLogoProductora()
    {
        $this->validateToken();
    
        if (empty($_POST['idProductora'])) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"idProductora es requerido"]);
            exit();
        }
        $idProductora = (int)$_POST['idProductora'];
    
        if (!isset($_FILES['logo']) || $_FILES['logo']['error'] !== UPLOAD_ERR_OK) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"Archivo logo inválido"]);
            exit();
        }
    
        // Validación fuerte
        $max = 2 * 1024 * 1024; // 2MB
        if ($_FILES['logo']['size'] > $max) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"Máximo 2MB"]);
            exit();
        }
    
        $finfo = new \finfo(FILEINFO_MIME_TYPE);
        $mime  = $finfo->file($_FILES['logo']['tmp_name']);
    
        $ext = null;
        if ($mime === 'image/jpeg') $ext = 'jpg';
        elseif ($mime === 'image/png') $ext = 'png';
        elseif ($mime === 'image/webp') $ext = 'webp';
    
        if (!$ext) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"Formato no permitido (jpg/png/webp)"]);
            exit();
        }
    
        $dirFs = __DIR__ . '/../../uploads/logosProductoras'; // ajusta según tu estructura real
        if (!is_dir($dirFs)) @mkdir($dirFs, 0755, true);
    
        $filename = 'productora_' . $idProductora . '_' . time() . '.' . $ext;
        $destFs = $dirFs . '/' . $filename;
    
        if (!move_uploaded_file($_FILES['logo']['tmp_name'], $destFs)) {
            http_response_code(500);
            echo json_encode(["status"=>"error","message"=>"No se pudo guardar el archivo"]);
            exit();
        }
    
        $urlPublica = 'https://api.ticketiza.cl/uploads/logosProductoras/' . $filename;
    
        $init = new Productora();
        $ok = $init->actualizarLogoProductora($idProductora, $urlPublica);
    
        if (!$ok) {
            // Opcional: borrar archivo si falla BD
            @unlink($destFs);
            echo json_encode(["status"=>"error","message"=>"No se pudo actualizar logo en BD"]);
            exit();
        }
    
        echo json_encode(["status"=>"ok","url"=>$urlPublica]);
    }
 
 
    public function InsertardatosProductora()
    {
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (empty($data['nombreProductora']) || empty($data['idUsuario'])) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Faltan campos obligatorios"
            ]);
            return;
        }

    
        $prod = new Productora();
        $ok = $prod->insertarProductora($data);
    
        if ($ok) {
            echo json_encode([
                "status" => "ok"
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status" => "error",
                "message" => "No se pudo insertar"
            ]);
        }
    }
      
    public function enviarCorreo()
    {
      
         $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
       
        if (
            empty($data['asunto']) ||
            empty($data['mensajeHtml']) ||
            empty($data['destinatarios'])
        ) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Faltan campos: asunto, mensajeHtml, destinatarios"
            ]);
            return;
        }
    
      
        $destinatarios = is_array($data['destinatarios'])
            ? $data['destinatarios']
            : [$data['destinatarios']];
    
       
        include '/home/aigc/public_html/includes/vendor/phpmailer/src/Exception.php';
        include '/home/aigc/public_html/includes/vendor/phpmailer/src/PHPMailer.php';
        include '/home/aigc/public_html/includes/vendor/phpmailer/src/SMTP.php';
    
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
    
        try {
           
            $mail->isSMTP();
            $mail->Host       = 'smtp-relay.gmail.com';
            $mail->Port       = 587;
            $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
            $mail->SMTPAuth   = false; 
    
          
            $mail->setFrom('app@ticketiza.cl', 'Ticketiza');
           
            $mail->addReplyTo('app@ticketiza.cl', 'Ticketiza');
    
            // destinatarios
            foreach ($destinatarios as $dest) {
                $mail->addAddress($dest);
            }
    
            // contenido
            $mail->isHTML(true);
            $mail->Subject = $data['asunto'];
            $mail->Body    = $data['mensajeHtml'];
            
            $mail->AltBody = strip_tags($data['mensajeHtml']);
    
            // cabeceras “normales”
            $mail->addCustomHeader('X-Mailer', 'Ticketiza API');
            $mail->addCustomHeader('X-Priority', '3');
    
            $mail->send();
    
            echo json_encode([
                "status"  => "ok",
                "message" => "Correo enviado"
            ]);
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => "No se pudo enviar: " . $mail->ErrorInfo
            ]);
        }
    }
  
    public function buscarEvento()
    {
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
       // if (
       //     empty($data['busqueda']) || 
       //     empty($data['tipo'])  
       // ) {
       //     http_response_code(400);
       //     echo json_encode([
       //         "status" => "error",
       //         "message" => "Faltan campos obligatorios"
       //     ]);
       //     return;
       // }
        
    
        
    
        $prod = new Evento();
        $ok = $prod->buscarEvento($data['busqueda'],$data['tipo'],$data['region']);
        #print_r($ok);
        if ($ok) {
            echo json_encode([
                "status" => "ok","message" =>$ok
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status" => "error",
                "message" => "No se pudo obtener la busqueda"
            ]);
        }
    }
     
   public function registrar()
{
    // Si quieres que el registro sea público, comenta la línea de abajo.
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (
        empty($data['tipo']) ||
        empty($data['nombre']) ||
        empty($data['apellido']) ||
        empty($data['rut']) ||
        empty($data['correo']) ||
        empty($data['usuario']) ||
        empty($data['clave'])
    ) {
        // Para este caso, si quieres, puedes dejar 400 (falta de datos)
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos para registrar usuario"
        ]);
        return;
    }

    $usuarioModel = new UsuarioPortal();
    $result       = $usuarioModel->registrar($data);

    header('Content-Type: application/json; charset=utf-8');

    if ($result['ok']) {
        // OK: 200
        echo json_encode([
            "status" => "ok",
            "id"     => $result['id']
        ]);
    } else {
        // ❗ OJO: ya NO enviamos 500 aquí
        // Es un error de validación (rut duplicado, correo duplicado, etc.)
        http_response_code(200);
        echo json_encode([
            "status"  => "error",
            "message" => $result['message'] ?? 'Error al registrar'
        ]);
    }
}


    public function datosPersonales()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $tipo = $data['tipo'] ?? null;
        $id   = isset($data['id']) ? (int)$data['id'] : 0;

        if (!$tipo || !$id) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "tipo e id son requeridos"
            ]);
            return;
        }

        // Por ahora solo manejamos tipo 'usuario'
        if ($tipo !== 'usuario') {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "tipo no soportado"
            ]);
            return;
        }

        $usuarioModel = new UsuarioPortal();
        $result       = $usuarioModel->getDatosPersonales($id);

        if ($result['ok']) {
            echo json_encode([
                "status" => "ok",
                "data"   => $result['data']
            ]);
        } else {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message']
            ]);
        }
    }

    public function actualizaDatosPersonales()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $tipo = $data['tipo'] ?? null;
        $id   = isset($data['id']) ? (int)$data['id'] : 0;
        $datos = $data['datos'] ?? [];

        if (!$tipo || !$id || empty($datos)) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "tipo, id y datos son requeridos"
            ]);
            return;
        }

        if ($tipo !== 'usuario') {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "tipo no soportado"
            ]);
            return;
        }

        $usuarioModel = new UsuarioPortal();
        $result       = $usuarioModel->actualizarDatosPersonales($id, $datos);

        if ($result['ok']) {
            echo json_encode([
                "status" => "ok"
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message']
            ]);
        }
    }

    public function cambiarClave()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $id   = isset($data['id']) ? (int)$data['id'] : 0;

        if (!$id) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "id es requerido"
            ]);
            return;
        }

        
        $nuevaClave = bin2hex(random_bytes(4)); // 8 caracteres hex
        $hash       = password_hash($nuevaClave, PASSWORD_BCRYPT);

        $usuarioModel = new UsuarioPortal();
        $resClave     = $usuarioModel->actualizarClave($id, $hash);

        if (!$resClave['ok']) {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $resClave['message']
            ]);
            return;
        }

        $resCorreo = $usuarioModel->getCorreoPorId($id);
        if (!$resCorreo['ok']) {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => "No se pudo obtener el correo del usuario"
            ]);
            return;
        }

        $correo = $resCorreo['correo'];

        // Aquí usamos la misma lógica de enviarCorreo:
        // armamos un payload y llamamos internamente al "motor" de envío.
        // Como tu enviarCorreo actual lee php://input, lo ideal sería factorizar el código
        // de PHPMailer en un método privado. Aquí simulo un método privado:
        $asunto      = "Cambio de clave Ticketiza";
        $mensajeHtml = "<p>Se ha generado una nueva clave temporal para tu cuenta.</p>"
                     . "<p><strong>Clave:</strong> {$nuevaClave}</p>"
                     . "<p>Te recomendamos cambiarla al iniciar sesión.</p>";

        $okEnvio = $this->enviarCorreoInterno($asunto, $mensajeHtml, [$correo]);
       # print_r($correo);
        if (!$okEnvio) {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => "Clave actualizada, pero no se pudo enviar el correo"
            ]);
            return;
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Clave actualizada y correo enviado"
        ]);
    }
 
    public function enviarCorreoInterno(string $asunto, string $mensajeHtml, array $destinatarios): bool
    {
    // Validaciones básicas
    if (empty($asunto) || empty($mensajeHtml) || empty($destinatarios)) {
        return false;
    }

    // Asegurarse que siempre sea array
    $destinatarios = is_array($destinatarios) ? $destinatarios : [$destinatarios];

    // Cargar PHPMailer
    include '/home/aigc/public_html/includes/vendor/phpmailer/src/Exception.php';
    include '/home/aigc/public_html/includes/vendor/phpmailer/src/PHPMailer.php';
    include '/home/aigc/public_html/includes/vendor/phpmailer/src/SMTP.php';

    $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

    try {
        // Configuración SMTP (igual que en tu enviarCorreo normal)
        $mail->isSMTP();
        $mail->Host       = 'smtp-relay.gmail.com';
        $mail->Port       = 587;
        $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->SMTPAuth   = false;
        
        // 🔥 CLAVE PARA UTF-8
        $mail->CharSet  = 'UTF-8';
        $mail->Encoding = 'base64';

        // Remitente
        $mail->setFrom('app@ticketiza.cl', 'Ticketiza');
        $mail->addReplyTo('app@ticketiza.cl', 'Ticketiza');

        // Destinatarios
        foreach ($destinatarios as $dest) {
            if (!empty($dest)) {
                $mail->addAddress($dest);
            }
        }

        // Contenido
        $mail->isHTML(true);
        $mail->Subject = $asunto;
        $mail->Body    = $mensajeHtml;
        $mail->AltBody = strip_tags($mensajeHtml);

        // Cabeceras extra
        $mail->addCustomHeader('X-Mailer', 'Ticketiza API');
        $mail->addCustomHeader('X-Priority', '3');

        // Enviar
        $mail->send();
        return true;

    } catch (\PHPMailer\PHPMailer\Exception $e) {
        // Si quieres loguear el error:
        // error_log('Error enviando correo interno: ' . $mail->ErrorInfo);
        return false;
    }
}
  
    public function eliminarCuenta()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $id   = isset($data['id']) ? (int)$data['id'] : 0;

        if (!$id) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "id es requerido"
            ]);
            return;
        }

        $usuarioModel = new UsuarioPortal();
        $result       = $usuarioModel->marcarDesactivado($id);

        if ($result['ok']) {
            echo json_encode([
                "status"  => "ok",
                "message" => "Cuenta desactivada"
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message']
            ]);
        }
    }
 
    public function galeriaEvento()
    {
        $this->validateToken();

        $data    = json_decode(file_get_contents("php://input"), true);
        $idEvento = isset($data['id']) ? (int)$data['id'] : 0;

        if (!$idEvento) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "id (idEvento) es requerido"
            ]);
            return;
        }

        $galeriaModel = new GaleriaEvento();
        $items        = $galeriaModel->obtenerPorEvento($idEvento);

        echo json_encode([
            "status" => "ok",
            "data"   => $items
        ]);
    }

    public function actualizarGaleriaEvento()
    {
        $this->validateToken();

        $data   = json_decode(file_get_contents("php://input"), true);
        $idEvento = isset($data['id']) ? (int)$data['id'] : 0;
        $action = $data['action'] ?? null;
        $datos  = $data['datos'] ?? [];

        if (!$idEvento || !$action) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "id y action son requeridos"
            ]);
            return;
        }

        $galeriaModel = new GaleriaEvento();
        $result = null;

        switch ($action) {
            case 'agregar':
                $result = $galeriaModel->agregar($idEvento, $datos);
                break;
            case 'editar':
                if (empty($datos['id'])) {
                    http_response_code(400);
                    echo json_encode([
                        "status"  => "error",
                        "message" => "datos.id es requerido para editar"
                    ]);
                    return;
                }
                $result = $galeriaModel->actualizar((int)$datos['id'], $datos);
                break;
            case 'eliminar':
                if (empty($datos['id'])) {
                    http_response_code(400);
                    echo json_encode([
                        "status"  => "error",
                        "message" => "datos.id es requerido para eliminar"
                    ]);
                    return;
                }
                $result = $galeriaModel->eliminar((int)$datos['id']);
                break;
            default:
                http_response_code(400);
                echo json_encode([
                    "status"  => "error",
                    "message" => "action no válida"
                ]);
                return;
        }

        if (!empty($result['ok'])) {
            echo json_encode([
                "status" => "ok",
                "result" => $result
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message'] ?? 'Error en la galería'
            ]);
        }
    }
  
    public function listarticketpesos()
    {
        $this->validateToken();

        $data    = json_decode(file_get_contents("php://input"), true);
        $idusuario = isset($data['idusuario']) ? (int)$data['idusuario'] : 0;

        if (!$idusuario) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "idusuario es requerido"
            ]);
            return;
        }
        
 
        $carroModel = new ticketPesos();
        $resumen    = $carroModel->ticketPesos($idusuario);

        echo json_encode([
            "status"  => "ok",
            "resumen" => $resumen
        ]);
    }  
  
    public function resumenCarro()
    {
        $this->validateToken();

        $data    = json_decode(file_get_contents("php://input"), true);
        $idCarro = isset($data['idcarro']) ? (int)$data['idcarro'] : 0;
        $idEvento = isset($data['idEvento']) ? (int)$data['idEvento'] : 0;

        if (!$idCarro) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "idcarro es requerido"
            ]);
            return;
        }
        
        if (!$idEvento) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "idEvento es requerido"
            ]);
            return;
        }
 
        $carroModel = new CarroCompra();
        $resumen    = $carroModel->resumenPorUsuario($idCarro, $idEvento);

        echo json_encode([
            "status"  => "ok",
            "resumen" => $resumen
        ]);
    }
    
    public function limpiarCarroEvento()
    {
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        $idEvento  = (int)($data['idEvento'] ?? 0);
        $usuarioId = (int)($data['usuarioId'] ?? 0);
    
        if (!$idEvento || !$usuarioId) {
            http_response_code(400);
            echo json_encode([
                'status'  => 'error',
                'message' => 'idEvento y usuarioId requeridos'
            ]);
            return;
        }
    
        $carro = new CarroCompra();
        $ok = $carro->limpiarCarroPorEvento($usuarioId, $idEvento);
    
        echo json_encode([
            'status'  => $ok ? 'ok' : 'error',
            'message' => $ok ? 'Carro limpiado' : 'Nada que limpiar'
        ]);
    }




    public function resumenCarroPago()
    {
        $this->validateToken();
    
        $data    = json_decode(file_get_contents("php://input"), true);
        $ventaId = isset($data['ventaId']) ? (int)$data['ventaId'] : 0;
    
        if (!$ventaId) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "ventaId es requerido"
            ]);
            return;
        }
    
      
        $pagoModel = new CarroCompra(); 
    
        $resumen = $pagoModel->resumenPorVenta($ventaId);
    
        if (empty($resumen) || empty($resumen['ok'])) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => $resumen['message'] ?? "No se encontró pago para la ventaId indicada"
            ]);
            return;
        }
    
        echo json_encode([
            "status" => "ok",
            "data"   => $resumen
        ]);
    }



    public function agregaCarro()
    {
        $this->validateToken();

        $data        = json_decode(file_get_contents("php://input"), true);
        $idCarro     = isset($data['idcarro']) ? (int)$data['idcarro'] : 0;
        $idProducto  = isset($data['idproducto']) ? (int)$data['idproducto'] : 0;
        $cantidad    = isset($data['cantidad']) ? (int)$data['cantidad'] : 1;
        $tipo        = $data['tipo'] ?? 'normal';
        $tipoTransaccion = isset($data['tipoTransaccion']) ? (int)$data['tipoTransaccion'] : null;
        
        // Normalizar a boolean
        $tipoTransaccion = $tipoTransaccion ? 1 : 0;


        if (!$idCarro || !$idProducto ) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "idcarro e idproducto  son requeridos"
            ]);
            return;
        }

        $carroModel = new CarroCompra();
        $result     = $carroModel->agregar($idCarro, $idProducto, $cantidad, $tipo, $tipoTransaccion);

        if ($result['ok']) {
            echo json_encode([
                "status" => "ok",
                "id"     => $result['id']
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message']
            ]);
        }
    }

    public function editaCarro()
    {
        $this->validateToken();

        $data        = json_decode(file_get_contents("php://input"), true);
        $idCarro     = isset($data['id_carro']) ? (int)$data['id_carro'] : 0;
        $idProducto  = isset($data['id_producto']) ? (int)$data['id_producto'] : 0;
        $cantidad    = isset($data['cantidad']) ? (int)$data['cantidad'] : 1;
        $accion      = $data['accion'] ?? null;
        $tipo        = $data['tipo'] ?? 'normal';

        if (!$idCarro || !$idProducto || !$accion) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "id_carro, id_producto y accion son requeridos"
            ]);
            return;
        }

        $carroModel = new CarroCompra();
        $result     = $carroModel->editar($idCarro, $idProducto, $cantidad, $accion, $tipo);

        if (!empty($result['ok'])) {
            echo json_encode([
                "status" => "ok",
                "result" => $result
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => $result['message'] ?? 'Error al editar el carro'
            ]);
        }
    }
    
    public function misEventos()
    {
    $this->validateToken();

    $data      = json_decode(file_get_contents("php://input"), true);
    $usuarioId = isset($data['usuarioId']) ? (int)$data['usuarioId'] : 0;

    if (!$usuarioId) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "usuarioId es requerido"
        ]);
        return;
    }

    $model  = new EventosUsuario();
    $eventos = $model->obtenerEventosPorUsuario($usuarioId);

    echo json_encode([
        "status" => "ok",
        "data"   => $eventos
    ]);
}

    public function tipoTicket()
    {
    $this->validateToken();

    $data     = json_decode(file_get_contents("php://input"), true);
    $idEvento = isset($data['idEvento']) ? (int)$data['idEvento'] : 0;

    if (!$idEvento) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEvento es requerido"
        ]);
        return;
    }

    $model = new EntradasEventoModel();
    $tipos = $model->obtenerTiposPorEvento($idEvento);

    echo json_encode([
        "status" => "ok",
        "data"   => $tipos
    ]);
}

    public function tipoConsumo()
    {
    $this->validateToken();

    $data     = json_decode(file_get_contents("php://input"), true);
    $idEvento = isset($data['idEvento']) ? (int)$data['idEvento'] : 0;

    if (!$idEvento) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEvento es requerido"
        ]);
        return;
    }

    $model    = new ConsumoEvento();
    $consumos = $model->obtenerPorEvento($idEvento);

    echo json_encode([
        "status" => "ok",
        "data"   => $consumos
    ]);
}

    public function agregarEvento()
    {
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (
        empty($data['idProductora']) ||
        empty($data['tituloEvento']) ||
        empty($data['diaEvento']) ||
        empty($data['HorainicioEvento'])
    ) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idProductora, tituloEvento, diaEvento y HorainicioEvento son requeridos"
        ]);
        return;
    }

    $model  = new EventoModel();
    $result = $model->agregarEvento($data);

    if ($result['ok']) {
        echo json_encode([
            "status"   => "ok",
            "idEvento" => $result['idEvento']
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => $result['message'] ?? 'Error al crear evento'
        ]);
    }
}

    public function agregarEntrada()
    {
      
        $this->validateToken();
    
       
        $data = json_decode(file_get_contents("php://input"), true) ?? [];
    
      
        $required = ['idEvento', 'tituloEntrada', 'precioEntrada', 'cantidadEntradas', 'finVentaEntradas'];
        foreach ($required as $campo) {
            if (!isset($data[$campo]) || $data[$campo] === '') {
                http_response_code(400);
                echo json_encode([
                    "status"  => "error",
                    "message" => "Falta el campo requerido: {$campo}"
                ]);
                return;
            }
        }
    
       
        if (!isset($data['descripcionEntrada'])) {
            $data['descripcionEntrada'] = null;
        }
        if (!isset($data['esNominativa'])) {
            $data['esNominativa'] = 0; 
        }
        if (!isset($data['camposNominativa'])) {
            $data['camposNominativa'] = null;
        }
    
       
        $evento = new Evento();
        $result = $evento->agregarEntrada($data);
    
        if (!empty($result['ok'])) {
            echo json_encode([
                "status"  => "ok",
                "message" => "Entrada creada correctamente",
                "data"    => [
                    "idEntradaEvento" => $result['idEntradaEvento'] ?? null
                ]
            ]);
        } else {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => "No se pudo crear la entrada",
                "error"   => $result['error'] ?? null
            ]);
        }
    }


    public function agregarConsumo()
    {
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (
        empty($data['idEvento']) ||
        empty($data['nombreConsumo']) ||
        !isset($data['precioConsumo']) ||
        !isset($data['stockConsumo'])
    ) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEvento, nombreConsumo, precioConsumo y stockConsumo son requeridos"
        ]);
        return;
    }

    $model  = new ConsumoEvento();
    $result = $model->agregar($data);

    if ($result['ok']) {
        echo json_encode([
            "status"          => "ok",
            "idConsumoEvento" => $result['id']
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => $result['message'] ?? 'Error al agregar consumo'
        ]);
    }
}

    public function editarEvento()
    {
    $this->validateToken();

    $data     = json_decode(file_get_contents("php://input"), true);
    $idEvento = isset($data['idEvento']) ? (int)$data['idEvento'] : 0;

    if (!$idEvento) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEvento es requerido"
        ]);
        return;
    }

    // Quitamos idEvento para que solo queden campos a actualizar
    unset($data['idEvento']);

    if (empty($data)) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "No hay datos para actualizar"
        ]);
        return;
    }

    $model  = new EventoModel();
    $result = $model->editarEvento($idEvento, $data);

    if ($result['ok']) {
        echo json_encode([
            "status" => "ok"
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => $result['message'] ?? 'Error al editar evento'
        ]);
    }
}

    public function editarConsumo()
    {
    $this->validateToken();

    $data            = json_decode(file_get_contents("php://input"), true);
    $idConsumoEvento = isset($data['idConsumoEvento']) ? (int)$data['idConsumoEvento'] : 0;

    if (!$idConsumoEvento) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idConsumoEvento es requerido"
        ]);
        return;
    }

    unset($data['idConsumoEvento']);

    if (empty($data)) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "No hay datos para actualizar"
        ]);
        return;
    }

    $model  = new ConsumoEvento();
    $result = $model->editar($idConsumoEvento, $data);

    if ($result['ok']) {
        echo json_encode([
            "status" => "ok"
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => $result['message'] ?? 'Error al editar consumo'
        ]);
    }
}

    

// ================= DATOS TRIBUTARIOS / MANDATO =================

public function obtenerDatosTributariosProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta idProductora"
        ]);
        return;
    }

    $model = new DatosTributariosProductora();
    $row = $model->obtenerPorProductora((int)$data['idProductora']);

    if (!$row) {
        echo json_encode([
            "status" => "ok",
            "message" => null
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => $row
    ]);
}

public function crearMandatoProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $idProductora = (int)($data['idProductora'] ?? 0);
    $nombreRep    = trim($data['nombreRepresentanteMandato'] ?? '');
    $rut          = trim($data['rut'] ?? '');
    $nCuenta      = trim((string)($data['numeroCuentaBanco'] ?? ''));
    $tCuenta      = trim($data['tipoCuentaBanco'] ?? '');
    $banco        = trim($data['banco'] ?? '');
    $correo       = trim($data['correoRebote'] ?? '');
    $porcentajeAccion = $data['porcentajeAccion'] ?? null;
    $eventosAsociados = $data['eventosAsociados'] ?? null;

    if (!$idProductora || !$nombreRep || !$rut || !$nCuenta || !$tCuenta || !$banco || !$correo) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"Faltan datos obligatorios."]);
        return;
    }

    if ($porcentajeAccion === null || !is_numeric($porcentajeAccion)) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"porcentajeAccion inválido."]);
        return;
    }

    $porcentajeAccion = (float)$porcentajeAccion;
    if ($porcentajeAccion < 0 || $porcentajeAccion > 100) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"porcentajeAccion fuera de rango (0 a 100)."]);
        return;
    }

    // Validación + normalización de eventosAsociados
    if (!is_array($eventosAsociados) || !array_key_exists('all', $eventosAsociados)) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"eventosAsociados inválido (debe incluir all)."]);
        return;
    }

    $all = (bool)$eventosAsociados['all'];

    if ($all) {
        $eventosAsociados = ["all" => true];
    } else {
        $evs = $eventosAsociados['eventos'] ?? null;

        if (!is_array($evs) || count($evs) < 1) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"Debes seleccionar al menos 1 evento o marcar all=true."]);
            return;
        }

        $evs = array_values(array_unique(array_filter(array_map('intval', $evs), fn($n) => $n > 0)));

        if (!count($evs)) {
            http_response_code(400);
            echo json_encode(["status"=>"error","message"=>"Lista de eventos inválida."]);
            return;
        }

        $eventosAsociados = ["all" => false, "eventos" => $evs];
    }

    $eventosAsociadosJson = json_encode($eventosAsociados, JSON_UNESCAPED_UNICODE);
    if ($eventosAsociadosJson === false) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"No se pudo serializar eventosAsociados."]);
        return;
    }

    // Instancia UNA vez el modelo (antes de usarlo)
    $model = new DatosTributariosProductora();

    // ================== VALIDACIÓN % POR EVENTO (NO SUPERAR 100) ==================
    $eventRows = $model->obtenerEventosPorProductora($idProductora);

    $eventTitleById = [];
    $eventIdsProductora = [];
    foreach ($eventRows as $er) {
        $eid = (int)$er['idEvento'];
        $eventIdsProductora[] = $eid;
        $eventTitleById[$eid] = (string)$er['tituloEvento'];
    }
    $eventIdsProductora = array_values(array_unique($eventIdsProductora));

    // Si all=true pero la productora no tiene eventos, evita crear un mandato "all" sin eventos reales
    if ($eventosAsociados['all'] === true && !count($eventIdsProductora)) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"La productora no tiene eventos para asociar el mandato (all=true)."]);
        return;
    }

    $targetEvents = ($eventosAsociados['all'] === true)
        ? $eventIdsProductora
        : array_map('intval', $eventosAsociados['eventos'] ?? []);

    // Validar pertenencia si no es all
    if (!$eventosAsociados['all']) {
        $allowed = array_flip($eventIdsProductora);
        foreach ($targetEvents as $eid) {
            if (!isset($allowed[(int)$eid])) {
                http_response_code(400);
                echo json_encode([
                    "status" => "error",
                    "message" => "Evento inválido: no pertenece a esta productora (idEvento={$eid})."
                ]);
                return;
            }
        }
    }

    $mandatosActivos = $model->obtenerMandatosActivosPorProductora($idProductora);

    $usedByEvent = [];
    foreach ($eventIdsProductora as $eid) {
        $usedByEvent[$eid] = 0.0;
    }

    foreach ($mandatosActivos as $m) {
        $p = (float)$m['porcentajeAccion'];
        $ev = json_decode((string)$m['eventosAsociados'], true);

        if (!is_array($ev) || !array_key_exists('all', $ev)) {
            continue;
        }

        if (!empty($ev['all'])) {
            foreach ($usedByEvent as $eid => $cur) {
                $usedByEvent[$eid] = $cur + $p;
            }
        } else {
            $list = $ev['eventos'] ?? [];
            if (!is_array($list)) $list = [];
            foreach ($list as $eid) {
                $eid = (int)$eid;
                if (array_key_exists($eid, $usedByEvent)) {
                    $usedByEvent[$eid] += $p;
                }
            }
        }
    }

    $nuevo = (float)$porcentajeAccion;
    $violaciones = [];

    foreach ($targetEvents as $eid) {
        $eid = (int)$eid;
        if (!array_key_exists($eid, $usedByEvent)) continue;

        $usado = (float)$usedByEvent[$eid];

        if (($usado + $nuevo) > 100.00001) {
            $disp = max(0, 100 - $usado);
            $violaciones[] = [
                'idEvento' => $eid,
                'tituloEvento' => $eventTitleById[$eid] ?? ("Evento #".$eid),
                'porcentajeUsado' => $usado,
                'porcentajeNuevo' => $nuevo,
                'porcentajeDisponible' => $disp
            ];
        }
    }

    if (!empty($violaciones)) {
        http_response_code(409);

        $msgs = [];
        foreach ($violaciones as $v) {
            $msgs[] = "No puedes asignar {$v['porcentajeNuevo']}% a \"{$v['tituloEvento']}\" porque ya hay {$v['porcentajeUsado']}% asignado. Disponible: {$v['porcentajeDisponible']}%.";
        }

        echo json_encode([
            "status" => "error",
            "message" => implode(" ", $msgs),
            "reason"  => "PORCENTAJE_SUPERA_100",
            "details" => $violaciones
        ]);
        return;
    }
    // ================== FIN VALIDACIÓN ==================

    // Insert
    $ok = $model->insertarMandato([
        'idProductora' => $idProductora,
        'nombreRepresentanteMandato' => $nombreRep,
        'rut' => $rut,
        'numeroCuentaBanco' => $nCuenta,
        'tipoCuentaBanco' => $tCuenta,
        'banco' => $banco,
        'correoRebote' => $correo,
        'porcentajeAccion' => $porcentajeAccion,
        'eventosAsociados' => $eventosAsociadosJson,
        'estadoMandato' => 'Activado'
    ]);

    if (!$ok) {
        http_response_code(500);
        echo json_encode(["status"=>"error","message"=>"No se pudo crear el mandato."]);
        return;
    }

    echo json_encode(["status"=>"ok","message"=>"Mandato creado."]);
}



public function revocarMandatoProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $idProductora = (int)($data['idProductora'] ?? 0);
    $idMandato    = (int)($data['idMandato'] ?? 0);

    if (!$idProductora || !$idMandato) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Faltan datos (idProductora / idMandato)."
        ]);
        return;
    }

    $model = new DatosTributariosProductora();
    $ok = $model->cambiarEstadoMandato($idMandato, $idProductora, 'Desactivado');

    if (!$ok) {
        http_response_code(500);
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo revocar el mandato."
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => "Mandato revocado (Desactivado)."
    ]);
}


public function editarMandatoProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $idMandato    = (int)($data['idMandato'] ?? 0);
    $idProductora = (int)($data['idProductora'] ?? 0);

    $nombreRep = trim($data['nombreRepresentanteMandato'] ?? '');
    $rut       = trim($data['rut'] ?? '');
    $nCuenta   = trim((string)($data['numeroCuentaBanco'] ?? ''));
    $tCuenta   = trim($data['tipoCuentaBanco'] ?? '');
    $banco     = trim($data['banco'] ?? '');
    $correo    = trim($data['correoRebote'] ?? '');
    $porcentajeAccion = $data['porcentajeAccion'] ?? null;

    // NUEVO
    $eventosAsociados = $data['eventosAsociados'] ?? null;

    if (!$idMandato || !$idProductora || !$nombreRep || !$rut || !$nCuenta || !$tCuenta || !$banco || !$correo) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Faltan datos obligatorios."
        ]);
        return;
    }

    if ($porcentajeAccion === null || !is_numeric($porcentajeAccion)) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"porcentajeAccion inválido."]);
        return;
    }
    
    $porcentajeAccion = (float)$porcentajeAccion;
    if ($porcentajeAccion < 0 || $porcentajeAccion > 100) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"porcentajeAccion fuera de rango (0 a 100)."]);
        return;
    }


    // Validación + normalización igual que CREAR
    if (!is_array($eventosAsociados) || !array_key_exists('all', $eventosAsociados)) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "eventosAsociados inválido (debe incluir all)."
        ]);
        return;
    }

    $all = (bool)$eventosAsociados['all'];

    if ($all) {
        $eventosAsociados = ["all" => true];
    } else {
        $evs = $eventosAsociados['eventos'] ?? null;

        if (!is_array($evs) || count($evs) < 1) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Debes seleccionar al menos 1 evento o marcar all=true."
            ]);
            return;
        }

        $evs = array_values(array_unique(array_filter(array_map('intval', $evs), function($n){
            return $n > 0;
        })));

        if (!count($evs)) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Lista de eventos inválida."
            ]);
            return;
        }

        $eventosAsociados = [
            "all" => false,
            "eventos" => $evs
        ];
    }

    $eventosAsociadosJson = json_encode($eventosAsociados, JSON_UNESCAPED_UNICODE);
    if ($eventosAsociadosJson === false) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo serializar eventosAsociados."
        ]);
        return;
    }

    $model = new DatosTributariosProductora();
    $ok = $model->editarMandato(
        $idMandato,
        $idProductora,
        [
            'nombreRepresentanteMandato' => $nombreRep,
            'rut' => $rut,
            'numeroCuentaBanco' => $nCuenta,
            'tipoCuentaBanco' => $tCuenta,
            'banco' => $banco,
            'porcentajeAccion' => $porcentajeAccion,
            'correoRebote' => $correo,
            'eventosAsociados' => $eventosAsociadosJson
        ]
    );

    if (!$ok) {
        http_response_code(500);
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo actualizar el mandato."
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => "Mandato actualizado."
    ]);
}



public function guardarDatosTributariosProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = [
        'idProductora', 'razonSocial', 'rut', 'direccion', 'giro', 'correoDte',
        'nombreRepLegal', 'rutRepLegal', 'biometria', 'mrz', 'vigencia'
    ];

    foreach ($required as $field) {
        if (!isset($data[$field]) || $data[$field] === '') {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo obligatorio: {$field}"
            ]);
            return;
        }
    }

    $payload = [
        'idProductora'        => (int)$data['idProductora'],
        'razonSocial'         => $data['razonSocial'],
        'rut'                 => $data['rut'],
        'direccion'           => $data['direccion'],
        'giro'                => $data['giro'],
        'correoDte'           => $data['correoDte'],
        'nombreRepLegal'      => $data['nombreRepLegal'],
        'rutRepLegal'         => $data['rutRepLegal'],
        'fotoCiDelantera'     => $data['fotoCiDelantera'] ?? null,
        'fotoCiTrasera'       => $data['fotoCiTrasera'] ?? null,
        'numeroCuentaBanco'   => $data['numeroCuentaBanco'] ?? null,
        'tipoCuentaBanco'     => $data['tipoCuentaBanco'] ?? null,
        'banco'               => $data['banco'] ?? null,
        'urlMandato'          => $data['urlMandato'] ?? null,
        'fechaFirmaMandato'   => $data['fechaFirmaMandato'] ?? null,
        'fechaExpiracionMandato' => $data['fechaExpiracionMandato'] ?? null,
        'biometria'           => $data['biometria'],
        'mrz'                 => $data['mrz'],
        'vigencia'            => $data['vigencia'],
    ];

    $model = new DatosTributariosProductora();
    $ok = $model->guardar($payload);

    echo json_encode([
        "status"  => $ok ? "ok" : "error",
        "message" => $ok ? "Datos tributarios guardados" : "No se pudieron guardar los datos"
    ]);
}

// ================= DTE / FACTURACIÓN =================

public function obtenerDtePorVenta()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['ventaId'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta ventaId"
        ]);
        return;
    }

    $model = new DteModel();
    $rows = $model->obtenerPorVenta((int)$data['ventaId']);

    echo json_encode([
        "status" => "ok",
        "message" => $rows
    ]);
}

public function crearDteVenta()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = ['ventaId','dteTipoId','folio'];
    foreach ($required as $f) {
        if (empty($data[$f])) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo: {$f}"
            ]);
            return;
        }
    }

    $payload = [
        'ventaId'      => (int)$data['ventaId'],
        'dteTipoId'    => (int)$data['dteTipoId'],
        'folio'        => (int)$data['folio'],
        'estadoDte'    => $data['estadoDte'] ?? 'pendiente',
        'fechaEmision' => $data['fechaEmision'] ?? date('Y-m-d H:i:s'),
        'fechaEnvioSii'=> $data['fechaEnvioSii'] ?? null,
        'xmlPath'      => $data['xmlPath'] ?? null,
        'pdfPath'      => $data['pdfPath'] ?? null,
        'glosaRechazo' => $data['glosaRechazo'] ?? null,
    ];

    $model = new DteModel();
    $id = $model->crear($payload);

    if ($id === false) {
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo crear el DTE"
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => ["id" => $id]
    ]);
}

// ================= RETIROS ANTICIPADOS =================

public function solicitarRetiroAnticipado()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = ['idEvento','idProductora','montoRetiro'];
    foreach ($required as $f) {
        if (!isset($data[$f]) || $data[$f] === '') {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo: {$f}"
            ]);
            return;
        }
    }

    $model = new RetirosAnticipados();
    $id = $model->crear(
        (int)$data['idEvento'],
        (int)$data['idProductora'],
        (int)$data['montoRetiro'],
        $data['observaciones'] ?? null
    );

    if ($id === false) {
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo registrar el retiro"
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => ["idRetiro" => $id]
    ]);
}

public function listarRetirosProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta idProductora"
        ]);
        return;
    }

    $model = new RetirosAnticipados();
    $rows = $model->listarPorProductora((int)$data['idProductora']);

    echo json_encode([
        "status" => "ok",
        "message" => $rows
    ]);
}

public function actualizarEstadoRetiro()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = ['idRetiro','estadoRetiro'];
    foreach ($required as $f) {
        if (!isset($data[$f])) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo: {$f}"
            ]);
            return;
        }
    }

    $fechaPago = $data['fechaPago'] ?? null;
    $observaciones = $data['observaciones'] ?? null;

    $model = new RetirosAnticipados();
    $ok = $model->actualizarEstado(
        (int)$data['idRetiro'],
        (int)$data['estadoRetiro'],
        $fechaPago,
        $observaciones
    );

    echo json_encode([
        "status" => $ok ? "ok" : "error",
        "message" => $ok ? "Retiro actualizado" : "No se pudo actualizar el retiro"
    ]);
}

// ================= CONTACTOS DE EMERGENCIA =================

public function listarContactosEmergencia()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['usuarioId'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta usuarioId"
        ]);
        return;
    }

    $model = new UsuarioContactoEmergencia();
    $rows = $model->listarPorUsuario((int)$data['usuarioId']);

    echo json_encode([
        "status" => "ok",
        "message" => $rows
    ]);
}

public function guardarContactoEmergencia()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = ['usuarioId','nombreContacto','telefonoContacto','prioridad'];
    foreach ($required as $f) {
        if (!isset($data[$f]) || $data[$f] === '') {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo: {$f}"
            ]);
            return;
        }
    }

    $payload = [
        'idContactoEmergencia' => $data['idContactoEmergencia'] ?? null,
        'usuarioId'            => (int)$data['usuarioId'],
        'nombreContacto'       => $data['nombreContacto'],
        'telefonoContacto'     => $data['telefonoContacto'],
        'prioridad'            => (int)$data['prioridad'],
        'activo'               => isset($data['activo']) ? (int)$data['activo'] : 1,
    ];

    $model = new UsuarioContactoEmergencia();
    $id = $model->guardar($payload);

    if ($id === false) {
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo guardar el contacto"
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => ["idContactoEmergencia" => $id]
    ]);
}

public function eliminarContactoEmergencia()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['idContactoEmergencia']) || empty($data['usuarioId'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Faltan idContactoEmergencia y/o usuarioId"
        ]);
        return;
    }

    $model = new UsuarioContactoEmergencia();
    $ok = $model->eliminarLogico(
        (int)$data['idContactoEmergencia'],
        (int)$data['usuarioId']
    );

    echo json_encode([
        "status" => $ok ? "ok" : "error",
        "message" => $ok ? "Contacto desactivado" : "No se pudo desactivar el contacto"
    ]);
}




// ================= BOTÓN DE PÁNICO =================

public function activarBotonPanico()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['usuarioId'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta usuarioId"
        ]);
        return;
    }

    $usuarioId    = (int)$data['usuarioId'];
    $idProductora = isset($data['idProductora']) ? (int)$data['idProductora'] : null;
    $idEvento     = isset($data['idEvento']) ? (int)$data['idEvento'] : null;
    $mensaje      = $data['mensajeInicial'] ?? 'Se ha activado el botón de pánico Ticketiza.';

    $model = new BotonPanico();
    $res = $model->crearEvento($usuarioId, $idProductora, $idEvento, $mensaje);

    if ($res === false) {
        echo json_encode([
            "status" => "error",
            "message" => "No se pudo crear el evento de pánico"
        ]);
        return;
    }

    $mensajeWhatsApp = $mensaje . ' Seguimiento en tiempo real: ' .
        ($data['urlSeguimiento'] ?? 'https://ticketiza.cl/panico/' . $res['tokenPublico']);

    $cantNotif = $model->crearNotificacionesParaContactos(
        $res['idBotonPanico'],
        $usuarioId,
        $mensajeWhatsApp
    );

    echo json_encode([
        "status" => "ok",
        "message" => [
            "idBotonPanico" => $res['idBotonPanico'],
            "tokenPublico"  => $res['tokenPublico'],
            "notificacionesCreadas" => $cantNotif
        ]
    ]);
}

public function actualizarUbicacionBotonPanico()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    $required = ['idBotonPanico','latitud','longitud'];
    foreach ($required as $f) {
        if (!isset($data[$f])) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "Falta campo: {$f}"
            ]);
            return;
        }
    }

    $model = new BotonPanico();
    $ok = $model->registrarUbicacion(
        (int)$data['idBotonPanico'],
        (float)$data['latitud'],
        (float)$data['longitud'],
        isset($data['precisionMetros']) ? (float)$data['precisionMetros'] : null,
        isset($data['velocidad']) ? (float)$data['velocidad'] : null,
        isset($data['rumbo']) ? (int)$data['rumbo'] : null
    );

    echo json_encode([
        "status" => $ok ? "ok" : "error",
        "message" => $ok ? "Ubicación registrada" : "No se pudo registrar la ubicación"
    ]);
}

public function finalizarBotonPanico()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true) ?? [];

    if (empty($data['idBotonPanico']) || empty($data['estado'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Faltan idBotonPanico y/o estado"
        ]);
        return;
    }

    $estado = $data['estado'];
    $model = new BotonPanico();
    $ok = $model->finalizar((int)$data['idBotonPanico'], $estado);

    echo json_encode([
        "status" => $ok ? "ok" : "error",
        "message" => $ok ? "Evento de pánico actualizado" : "No se pudo actualizar el evento"
    ]);
}


public function guardarAsistenteEvento() {
    $this->validateToken();

    $input = json_decode(file_get_contents("php://input"), true);

    if (empty($input['idTransaccionCarro']) || empty($input['asistentes']) || !is_array($input['asistentes'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Datos inválidos. Se requiere idTransaccionCarro y asistentes[]"
        ]);
        return;
    }

    require_once __DIR__ . '/../models/transacciones/AsistenteEventoModel.php';
    $model = new AsistenteEventoModel();

    $ok = $model->guardarAsistentes($input['idTransaccionCarro'], $input['asistentes']);

    if ($ok) {
        echo json_encode([
            "status" => "ok",
            "message" => "Asistentes guardados correctamente"
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            "status" => "error",
            "message" => "Error al guardar asistentes"
        ]);
    }
}





    // Crea o devuelve el E-Ticket de una venta
    public function generarEticketVenta()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $ventaId = isset($data['ventaId']) ? (int)$data['ventaId'] : 0;

        if ($ventaId <= 0) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta parámetro ventaId"
            ]);
            return;
        }

        // Modelo
        $docModel = new VentaDocumentosPdf();

        // ¿Ya existe?
        $existente = $docModel->obtenerDocumentoPorVentaYTipo($ventaId, 'eticket');
        if ($existente && !empty($existente['rutaRelativa'])) {
            $url = self::PDF_BASE_URL . $existente['rutaRelativa'];
            echo json_encode([
                "status"  => "ok",
                "message" => "E-Ticket ya existente",
                "url"     => $url
            ]);
            return;
        }

        // Datos de venta
        $cabecera = $docModel->obtenerCabeceraVenta($ventaId);
        if (!$cabecera) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "Venta no encontrada"
            ]);
            return;
        }

        $detalles = $docModel->obtenerDetalleVenta($ventaId);
        if (!$detalles) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "La venta no tiene detalle"
            ]);
            return;
        }

        // Cargar FPDF
        require_once '../vendor/Fpdf/fpdf.php';

        // Definir directorio y archivo
        $subdir = 'etickets/';
        $filename = "eticket_venta_" . $ventaId . ".pdf";
        $relativePath = $subdir . $filename;
        $fullPath = self::PDF_BASE_DIR . $relativePath;

        if (!is_dir(dirname($fullPath))) {
            mkdir(dirname($fullPath), 0775, true);
        }

        // Crear PDF simple
        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);

        $pdf->Cell(0, 10, 'E-Ticket Ticketiza', 0, 1, 'C');
        $pdf->Ln(5);

        $pdf->SetFont('Arial', '', 11);
        $pdf->Cell(0, 6, 'Venta ID: ' . $ventaId, 0, 1);
        $pdf->Cell(0, 6, 'Cliente: ' . $cabecera['nombreUsuario'] . ' ' . $cabecera['apellidoUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'RUT: ' . $cabecera['rutUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'Correo: ' . $cabecera['correoUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'Fecha venta: ' . $cabecera['fechaVenta'], 0, 1);
        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 7, 'Entradas:', 0, 1);

        $pdf->SetFont('Arial', '', 10);
        foreach ($detalles as $linea) {
            $texto = sprintf(
                "%s - %s | Cant: %d | Precio: %s | Total: %s",
                $linea['tituloEvento'],
                $linea['tituloEntrada'],
                $linea['cantidad'],
                $linea['valorUnitario'],
                $linea['totalLinea']
            );
            $pdf->MultiCell(0, 5, $texto);
            $pdf->Ln(1);
        }

        $pdf->Ln(5);
        $pdf->SetFont('Arial', 'B', 11);
        $pdf->Cell(0, 6, 'Total venta: ' . $cabecera['total'] . ' ' . $cabecera['moneda'], 0, 1);

        // Guardar PDF
        $pdf->Output('F', $fullPath);

        // Registrar en BD
        $docModel->guardarDocumento($ventaId, 'eticket', $relativePath);

        $url = self::PDF_BASE_URL . $relativePath;
        echo json_encode([
            "status"  => "ok",
            "message" => "E-Ticket generado",
            "url"     => $url
        ]);
    }



    // Crea o devuelve el Recibo de compra de una venta
    public function generarReciboCompra()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $ventaId = isset($data['ventaId']) ? (int)$data['ventaId'] : 0;

        if ($ventaId <= 0) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta parámetro ventaId"
            ]);
            return;
        }

        $docModel = new VentaDocumentosPdf();

        // ¿Ya existe?
        $existente = $docModel->obtenerDocumentoPorVentaYTipo($ventaId, 'recibo');
        if ($existente && !empty($existente['rutaRelativa'])) {
            $url = self::PDF_BASE_URL . $existente['rutaRelativa'];
            echo json_encode([
                "status"  => "ok",
                "message" => "Recibo ya existente",
                "url"     => $url
            ]);
            return;
        }

        $cabecera = $docModel->obtenerCabeceraVenta($ventaId);
        if (!$cabecera) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "Venta no encontrada"
            ]);
            return;
        }

        $detalles = $docModel->obtenerDetalleVenta($ventaId);

        require_once '../vendor/Fpdf/fpdf.php';

        $subdir = 'recibos/';
        $filename = "recibo_venta_" . $ventaId . ".pdf";
        $relativePath = $subdir . $filename;
        $fullPath = self::PDF_BASE_DIR . $relativePath;

        if (!is_dir(dirname($fullPath))) {
            mkdir(dirname($fullPath), 0775, true);
        }

        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(0, 10, 'Recibo de compra', 0, 1, 'C');
        $pdf->Ln(5);

        $pdf->SetFont('Arial', '', 11);
        $pdf->Cell(0, 6, 'Venta ID: ' . $ventaId, 0, 1);
        $pdf->Cell(0, 6, 'Cliente: ' . $cabecera['nombreUsuario'] . ' ' . $cabecera['apellidoUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'RUT: ' . $cabecera['rutUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'Correo: ' . $cabecera['correoUsuario'], 0, 1);
        $pdf->Cell(0, 6, 'Fecha venta: ' . $cabecera['fechaVenta'], 0, 1);
        $pdf->Ln(5);

        // Tabla básica
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(80, 7, 'Item', 1);
        $pdf->Cell(20, 7, 'Cant', 1);
        $pdf->Cell(30, 7, 'Unitario', 1);
        $pdf->Cell(30, 7, 'Desc.', 1);
        $pdf->Cell(30, 7, 'Total', 1);
        $pdf->Ln();

        $pdf->SetFont('Arial', '', 9);
        foreach ($detalles as $linea) {
            $item = $linea['tituloEvento'] . ' - ' . $linea['tituloEntrada'];

            $pdf->Cell(80, 6, substr($item, 0, 40), 1);
            $pdf->Cell(20, 6, $linea['cantidad'], 1, 0, 'R');
            $pdf->Cell(30, 6, $linea['valorUnitario'], 1, 0, 'R');
            $pdf->Cell(30, 6, $linea['descuentoPesos'], 1, 0, 'R');
            $pdf->Cell(30, 6, $linea['totalLinea'], 1, 0, 'R');
            $pdf->Ln();
        }

        $pdf->Ln(5);
        $pdf->SetFont('Arial', 'B', 11);
        $pdf->Cell(0, 6, 'Neto: ' . $cabecera['totalNeto'] . ' ' . $cabecera['moneda'], 0, 1, 'R');
        $pdf->Cell(0, 6, 'IVA: ' . $cabecera['totalIva'] . ' ' . $cabecera['moneda'], 0, 1, 'R');
        $pdf->Cell(0, 6, 'Total: ' . $cabecera['total'] . ' ' . $cabecera['moneda'], 0, 1, 'R');

        $pdf->Ln(10);
        $pdf->SetFont('Arial', '', 9);
        $pdf->MultiCell(0, 5, 'Este recibo corresponde a una compra realizada a traves de Ticketiza. No reemplaza documentos tributarios oficiales (DTE).');

        $pdf->Output('F', $fullPath);

        $docModel->guardarDocumento($ventaId, 'recibo', $relativePath);

        $url = self::PDF_BASE_URL . $relativePath;
        echo json_encode([
            "status"  => "ok",
            "message" => "Recibo generado",
            "url"     => $url
        ]);
    }
    
    

    // Crea o devuelve el Ticket Fisico de una venta
    public function generarTicketFisico()
    {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        $ventaId = isset($data['ventaId']) ? (int)$data['ventaId'] : 0;

        if ($ventaId <= 0) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta parámetro ventaId"
            ]);
            return;
        }

        $docModel = new VentaDocumentosPdf();

        $existente = $docModel->obtenerDocumentoPorVentaYTipo($ventaId, 'ticket_fisico');
        if ($existente && !empty($existente['rutaRelativa'])) {
            $url = self::PDF_BASE_URL . $existente['rutaRelativa'];
            echo json_encode([
                "status"  => "ok",
                "message" => "Ticket físico ya existente",
                "url"     => $url
            ]);
            return;
        }

        $cabecera = $docModel->obtenerCabeceraVenta($ventaId);
        if (!$cabecera) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "Venta no encontrada"
            ]);
            return;
        }

        $detalles = $docModel->obtenerDetalleVenta($ventaId);
        if (!$detalles) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "La venta no tiene detalle"
            ]);
            return;
        }

        require_once '../vendor/Fpdf/fpdf.php';

        $subdir = 'ticketsFisicos/';
        $filename = "ticket_fisico_venta_" . $ventaId . ".pdf";
        $relativePath = $subdir . $filename;
        $fullPath = self::PDF_BASE_DIR . $relativePath;

        if (!is_dir(dirname($fullPath))) {
            mkdir(dirname($fullPath), 0775, true);
        }

        // Formato pensado para imprimir (por ejemplo 80mm ticketera -> A4 simplificado)
        $pdf = new FPDF('P', 'mm', 'A4');
        $pdf->SetMargins(10, 10, 10);
        $pdf->AddPage();

        foreach ($detalles as $linea) {
            // Un ticket por cada unidad
            for ($i = 0; $i < (int)$linea['cantidad']; $i++) {
                $pdf->SetFont('Arial', 'B', 14);
                $pdf->Cell(0, 7, 'Ticketiza - Ticket de Acceso', 0, 1, 'C');
                $pdf->Ln(2);

                $pdf->SetFont('Arial', '', 11);
                $pdf->Cell(0, 6, 'Evento: ' . $linea['tituloEvento'], 0, 1);
                $pdf->Cell(0, 6, 'Entrada: ' . $linea['tituloEntrada'], 0, 1);
                $pdf->Cell(0, 6, 'Precio: ' . $linea['valorUnitario'] . ' ' . $cabecera['moneda'], 0, 1);
                $pdf->Cell(0, 6, 'Cliente: ' . $cabecera['nombreUsuario'] . ' ' . $cabecera['apellidoUsuario'], 0, 1);
                $pdf->Cell(0, 6, 'RUT: ' . $cabecera['rutUsuario'], 0, 1);
                $pdf->Cell(0, 6, 'Venta ID: ' . $ventaId, 0, 1);
                $pdf->Cell(0, 6, 'Fecha venta: ' . $cabecera['fechaVenta'], 0, 1);

                $pdf->Ln(4);
                $pdf->SetFont('Arial', '', 9);
                $pdf->MultiCell(0, 4, 'Presentar este ticket en la entrada del evento. Ticket generado por Ticketiza.');

                // Pequeña separación entre tickets
                $pdf->Ln(10);

                // Si hay más tickets, forzamos nueva página al saturar
                if ($pdf->GetY() > 250) {
                    $pdf->AddPage();
                }
            }
        }

        $pdf->Output('F', $fullPath);

        $docModel->guardarDocumento($ventaId, 'ticket_fisico', $relativePath);

        $url = self::PDF_BASE_URL . $relativePath;
        echo json_encode([
            "status"  => "ok",
            "message" => "Ticket físico generado",
            "url"     => $url
        ]);
    }
    
    
    public function generarReciboCompraInterno(int $ventaId): array
    {
        if ($ventaId <= 0) {
            return ['success' => false, 'error' => 'ventaId inválido'];
        }
    
        $docModel = new VentaDocumentosPdf();
    
        // Seguridad de negocio: solo si está pagada
        // Si tu modelo no tiene este método aún, ver punto 3.
        if (method_exists($docModel, 'ventaEstaPagada') && !$docModel->ventaEstaPagada($ventaId)) {
            return ['success' => false, 'error' => 'Venta no está pagada'];
        }
    
        // ¿Ya existe?
        $existente = $docModel->obtenerDocumentoPorVentaYTipo($ventaId, 'recibo');
        if ($existente && !empty($existente['rutaRelativa'])) {
            $url = self::PDF_BASE_URL . $existente['rutaRelativa'];
            return ['success' => true, 'message' => 'Recibo ya existente', 'url' => $url];
        }
    
        $cabecera = $docModel->obtenerCabeceraVenta($ventaId);
        if (!$cabecera) {
            return ['success' => false, 'error' => 'Venta no encontrada'];
        }
    
        $detalles = $docModel->obtenerDetalleVenta($ventaId);
    
        
        require_once '../vendor/Fpdf/fpdf.php'; 
    
        $subdir = 'recibos/';
        $filename = "recibo_venta_" . $ventaId . ".pdf";
        $relativePath = $subdir . $filename;
        $fullPath = self::PDF_BASE_DIR . $relativePath;
    
        if (!is_dir(dirname($fullPath))) {
            mkdir(dirname($fullPath), 0775, true);
        }
    
        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(0, 10, 'Recibo de compra', 0, 1, 'C');
        $pdf->Ln(5);
    
        $pdf->SetFont('Arial', '', 11);
        $pdf->Cell(0, 6, 'Venta ID: ' . $ventaId, 0, 1);
        $pdf->Cell(0, 6, 'Cliente: ' . ($cabecera['nombreUsuario'] ?? '') . ' ' . ($cabecera['apellidoUsuario'] ?? ''), 0, 1);
        $pdf->Cell(0, 6, 'RUT: ' . ($cabecera['rutUsuario'] ?? ''), 0, 1);
        $pdf->Cell(0, 6, 'Correo: ' . ($cabecera['correoUsuario'] ?? ''), 0, 1);
        $pdf->Cell(0, 6, 'Fecha venta: ' . ($cabecera['fechaVenta'] ?? ''), 0, 1);
        $pdf->Ln(5);
    
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(80, 7, 'Item', 1);
        $pdf->Cell(20, 7, 'Cant', 1);
        $pdf->Cell(30, 7, 'Unitario', 1);
        $pdf->Cell(30, 7, 'Desc.', 1);
        $pdf->Cell(30, 7, 'Total', 1);
        $pdf->Ln();
    
        $pdf->SetFont('Arial', '', 9);
        foreach ($detalles as $linea) {
            $item = ($linea['tituloEvento'] ?? '') . ' - ' . ($linea['tituloEntrada'] ?? '');
            $pdf->Cell(80, 6, substr($item, 0, 40), 1);
            $pdf->Cell(20, 6, (string)($linea['cantidad'] ?? 0), 1, 0, 'R');
            $pdf->Cell(30, 6, (string)($linea['valorUnitario'] ?? 0), 1, 0, 'R');
            $pdf->Cell(30, 6, (string)($linea['descuentoPesos'] ?? 0), 1, 0, 'R');
            $pdf->Cell(30, 6, (string)($linea['totalLinea'] ?? 0), 1, 0, 'R');
            $pdf->Ln();
        }
    
        $pdf->Ln(5);
        $pdf->SetFont('Arial', 'B', 11);
        $pdf->Cell(0, 6, 'Neto: ' . ($cabecera['totalNeto'] ?? 0) . ' ' . ($cabecera['moneda'] ?? 'CLP'), 0, 1, 'R');
        $pdf->Cell(0, 6, 'IVA: ' . ($cabecera['totalIva'] ?? 0) . ' ' . ($cabecera['moneda'] ?? 'CLP'), 0, 1, 'R');
        $pdf->Cell(0, 6, 'Total: ' . ($cabecera['total'] ?? 0) . ' ' . ($cabecera['moneda'] ?? 'CLP'), 0, 1, 'R');
    
        $pdf->Ln(10);
        $pdf->SetFont('Arial', '', 9);
        $pdf->MultiCell(0, 5, 'Este recibo corresponde a una compra realizada a traves de Ticketiza. No reemplaza documentos tributarios oficiales (DTE).');
    
        $pdf->Output('F', $fullPath);
    
        $docModel->guardarDocumento($ventaId, 'recibo', $relativePath);
    
        $url = self::PDF_BASE_URL . $relativePath;
        return ['success' => true, 'message' => 'Recibo generado', 'url' => $url];
    }
    
    
    
    public function crearVentaDesdeCarro() {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);

        if (empty($data['usuarioId'])) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta usuarioId"
            ]);
            return;
        }
        
        if (empty($data['eventoId'])) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta usuarioId"
            ]);
            return;
        }

        $eventoId = (int)$data['eventoId'];
        $usuarioId = (int)$data['usuarioId'];
        $observaciones = $data['observaciones'] ?? null;

        $vp = new VentaProceso();
        $result = $vp->crearDesdeCarro($usuarioId, $eventoId , $observaciones);

        if (!$result['success']) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => $result['error'] ?? 'No se pudo crear la venta'
            ]);
            return;
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Venta creada desde carro",
            "data"    => $result
        ]);
    }


    public function iniciarPagoVenta() {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);

        if (empty($data['ventaId']) || empty($data['medioPagoCodigo'])) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Faltan campos: ventaId, medioPagoCodigo"
            ]);
            return;
        }

        $ventaId = (int)$data['ventaId'];
        $medioPagoCodigo = $data['medioPagoCodigo'];
        $extra = $data['extra'] ?? null;

        $vp = new VentaProceso();
        $result = $vp->iniciarPagoVenta($ventaId, $medioPagoCodigo, $extra);

        if (!$result['success']) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => $result['error'] ?? 'No se pudo iniciar el pago'
            ]);
            return;
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Pago iniciado",
            "data"    => $result
        ]);
    }


    public function webhookPagoMercadoPagoPabloRespaldo() {
        // OJO: aquí normalmente validas la firma/autenticación de la pasarela
        $data = json_decode(file_get_contents("php://input"), true);

        if (!is_array($data)) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Payload inválido"
            ]);
            return;
        }

        $remoteIp = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';

        $vp = new VentaProceso();
        $result = $vp->procesarWebhookPago($data, $remoteIp);

        if (!$result['success']) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => $result['error'] ?? 'No se pudo procesar webhook'
            ]);
            return;
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Webhook procesado",
            "data"    => $result
        ]);
    }
    
    public function webhookPagoMercadoPago()
    {
        $remoteIp = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    
        $rawBody = file_get_contents("php://input");
        $data    = json_decode($rawBody, true) ?: [];
    
        $vp = new VentaProcesoMercadoPago();
    
        // Si el body viene vacío, intentamos con POST o GET
        if (empty($data)) {
            if (!empty($_POST)) {
                $data = $_POST;
            } elseif (!empty($_GET)) {
                $data = $_GET;
            } else {
                http_response_code(400);
                echo json_encode([
                    "status"  => "error",
                    "message" => "Payload vacío"
                ]);
                return;
            }
        }
    
        $result = $vp->procesarWebhookPagoMP($data, $remoteIp);
    
        if (!$result['success']) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => $result['error'] ?? 'No se pudo procesar webhook'
            ]);
            return;
        }
    
        echo json_encode([
            "status"  => "ok",
            "message" => "Webhook procesado"
        ]);
    }


        
        
    public function webhookPagoMercadoPagoQr()
    {
        // sin validateToken llama Mercado Pago
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (!is_array($data)) {
            http_response_code(200); 
            echo json_encode([
                "status"  => "ignored",
                "message" => "Payload inválido o no JSON"
            ]);
            return;
        }
    
        $remoteIp = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    
        $vp = new VentaProcesoMercadoPago();
        $result = $vp->procesarWebhookPagoMPQr($data, $remoteIp);
    

        if (!$result['success']) {
 
            echo json_encode([
                "status"  => "ok",
                "message" => "Webhook QR procesado (con error interno)",
                "error"   => $result['error'] ?? null
            ]);
            return;
        }
    
        echo json_encode([
            "status"  => "ok",
            "message" => "Webhook QR procesado",
            "data"    => $result
        ]);
    }

 

public function resumenCompraVenta()
{
    header('Content-Type: application/json; charset=utf-8');

    $raw   = file_get_contents('php://input');
    $input = json_decode($raw, true) ?: [];

    $ventaId   = isset($input['ventaId'])   ? (int)$input['ventaId']   : 0;
    $usuarioId = isset($input['usuarioId']) ? (int)$input['usuarioId'] : 0;

    if ($ventaId <= 0) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'ventaId inválido'
        ]);
        return;
    }

 
    if ($usuarioId <= 0) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Usuario no autenticado'
        ]);
        return;
    }

    $vp = new VentaProcesoMercadoPago();
    $resumen = $vp->obtenerResumenCompra($ventaId, $usuarioId);

    if (!($resumen['success'] ?? false)) {
        echo json_encode([
            'status'  => 'error',
            'message' => $resumen['error'] ?? 'No se pudo obtener resumen'
        ]);
        return;
    }

    echo json_encode([
        'status' => 'ok',
        'data'   => $resumen['data']
    ]);
}



    public function detalleVenta() {
        $this->validateToken();

        $data = json_decode(file_get_contents("php://input"), true);
        if (empty($data['ventaId'])) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta ventaId"
            ]);
            return;
        }

        $ventaId = (int)$data['ventaId'];

        $vp = new VentaProceso();
        $result = $vp->obtenerDetalleVenta($ventaId);

        if (!$result['success']) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => $result['error'] ?? 'Venta no encontrada'
            ]);
            return;
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Detalle de venta",
            "data"    => $result
        ]);
    }
    
    public function clonarEvento()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idEventoOrigen']) || empty($data['diaEvento'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos: idEventoOrigen, diaEvento"
        ]);
        return;
    }

    try {
        $modelo = new EventoGestion();
        $resultado = $modelo->clonarEvento([
            'idEventoOrigen'  => (int)$data['idEventoOrigen'],
            'diaEvento'       => $data['diaEvento'],
            'HorainicioEvento'=> $data['HorainicioEvento'] ?? null
        ]);

        echo json_encode([
            "status"  => "ok",
            "message" => $resultado['mensaje'],
            "data"    => $resultado
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al clonar evento: " . $e->getMessage()
        ]);
    }
}


public function cuponAgregar()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    $requeridos = ['idEvento', 'codigoCupon', 'tipoDescuento', 'valorDescuento', 'stockTotal'];
    foreach ($requeridos as $campo) {
        if (empty($data[$campo]) && $data[$campo] !== "0") {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta campo: $campo"
            ]);
            return;
        }
    }

    try {
        $modelo = new CuponDescuentoModel();
        $cupon = $modelo->crearCupon([
            'idEvento'         => (int)$data['idEvento'],
            'codigoCupon'      => $data['codigoCupon'],
            'tipoDescuento'    => $data['tipoDescuento'],
            'valorDescuento'   => $data['valorDescuento'],
            'fechaInicio'      => $data['fechaInicio'] ?? null,
            'fechaFin'         => $data['fechaFin'] ?? null,
            'stockTotal'       => (int)$data['stockTotal'],
            'maximoPorUsuario' => isset($data['maximoPorUsuario']) ? (int)$data['maximoPorUsuario'] : 1,
            'estado'           => $data['estado'] ?? 'activo'
        ]);

        echo json_encode([
            "status" => "ok",
            "data"   => $cupon
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al crear cupón: " . $e->getMessage()
        ]);
    }
}

public function cuponEditar()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idCupon'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idCupon"
        ]);
        return;
    }

    try {
        $modelo = new CuponDescuentoModel();
        $cupon  = $modelo->actualizarCupon($data);

        echo json_encode([
            "status" => "ok",
            "data"   => $cupon
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al editar cupón: " . $e->getMessage()
        ]);
    }
}

public function cuponEliminar()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idCupon'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idCupon"
        ]);
        return;
    }

    try {
        $modelo = new CuponDescuentoModel();
        $ok     = $modelo->eliminarCupon((int)$data['idCupon']);

        echo json_encode([
            "status"  => $ok ? "ok" : "error",
            "message" => $ok ? "Cupón desactivado" : "No se pudo desactivar el cupón"
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al eliminar cupón: " . $e->getMessage()
        ]);
    }
}

public function cuponObtener()
{
    $this->validateToken();

    // Leemos el JSON de entrada
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['idCupon'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idCupon"
        ]);
        return;
    }

    $idCupon = (int)$data['idCupon'];
    if ($idCupon <= 0) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idCupon inválido"
        ]);
        return;
    }

    try {
        $modelo = new CuponDescuentoModel();
        $cupon  = $modelo->obtenerCupon($idCupon);

        if (!$cupon) {
            http_response_code(404);
            echo json_encode([
                "status"  => "error",
                "message" => "Cupón no encontrado"
            ]);
            return;
        }

        echo json_encode([
            "status" => "ok",
            "data"   => $cupon
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al obtener cupón: " . $e->getMessage()
        ]);
    }
}


public function enviarCortesiaEvento()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idEvento']) || empty($data['correoDestinatario'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos: idEvento, correoDestinatario"
        ]);
        return;
    }

    try {
        $modeloCupon = new CuponDescuentoModel();
        $resultado = $modeloCupon->crearCortesiaIndividual([
            'idEvento'          => (int)$data['idEvento'],
            'usuarioId'         => $data['usuarioId'] ?? null,
            'nombreDestinatario'=> $data['nombreDestinatario'] ?? null,
            'correoDestinatario'=> $data['correoDestinatario'],
        ]);

        $codigo    = $resultado['codigoCupon'];
        $asunto    = "Cortesía Ticketiza para tu evento";
        $nombre    = $data['nombreDestinatario'] ?? '';
        $mensajeHtml = "
            <p>Hola {$nombre},</p>
            <p>Has recibido una <strong>cortesía</strong> para un evento en Ticketiza.</p>
            <p>Tu código de cortesía es: <strong>{$codigo}</strong></p>
            <p>Úsalo al momento de comprar tus entradas.</p>
        ";

        // usamos enviarCorreoInterno ya existente
        $enviado = $this->enviarCorreoInterno(
            $asunto,
            $mensajeHtml,
            [$data['correoDestinatario']]
        );

        if ($enviado) {
            $modeloCupon->marcarCortesiaEnviada($resultado['idAsignacion']);
        }

        echo json_encode([
            "status"  => "ok",
            "message" => "Cortesía generada y correo enviado",
            "data"    => [
                "codigoCupon" => $codigo
            ]
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al generar/enviar cortesía: " . $e->getMessage()
        ]);
    }
}

public function listarCortesiasProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Falta campo: idProductora"
        ]);
        return;
    }

    $idProductora = (int)$data['idProductora'];

    try {
        $modelo = new CuponDescuentoModel();
        $resp = $modelo->listarCortesiasProductora($idProductora);

        echo json_encode([
            "status" => "ok",
            "data"   => $resp
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al obtener cortesías: " . $e->getMessage()
        ]);
    }
}


public function eventosPorProductora()
{
    // Valida token primero
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "El parámetro 'idProductora' es requerido"
        ]);
        exit();
    }

    $idProductora = (int)$data['idProductora'];

    
    $init = new perfilesProductoras();
    $mensaje = $init->listarEventosPorProductora($idProductora);

    if ($mensaje === false) {
        echo json_encode([
            "status"  => "error",
            "message" => "Hay un error en el sistema al listar eventos"
        ]);
    } else {
        echo json_encode([
            "status"  => "ok",
            "message" => $mensaje  
        ]);
    }
}


public function anularCortesia()
{
    // Autenticación / token
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idCupon'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "El parámetro 'idCupon' es requerido"
        ]);
        return;
    }

    $idCupon = (int)$data['idCupon'];

    try {
        // Usamos el mismo modelo de cupones que creaba la cortesía
        $modeloCupon = new CuponDescuentoModel();
        $ok = $modeloCupon->anularCortesia($idCupon);

        if ($ok) {
            echo json_encode([
                "status"  => "ok",
                "message" => "Cortesía anulada correctamente"
            ]);
        } else {
            echo json_encode([
                "status"  => "error",
                "message" => "No se pudo anular la cortesía (puede que ya esté inactiva o usada)"
            ]);
        }
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al anular cortesía: " . $e->getMessage()
        ]);
    }
}

public function reenviarCortesia()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idCupon'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "El parámetro 'idCupon' es requerido"
        ]);
        return;
    }

    $idCupon = (int)$data['idCupon'];

    try {
        $modeloCupon = new CuponDescuentoModel();
        $cortesia = $modeloCupon->obtenerCortesiaAsignadaPorCupon($idCupon);

        if (!$cortesia) {
            echo json_encode([
                "status"  => "error",
                "message" => "No se encontró la cortesía indicada"
            ]);
            return;
        }

        // Validaciones básicas
        if ($cortesia['tipoDescuento'] !== 'cortesia') {
            echo json_encode([
                "status"  => "error",
                "message" => "El cupón no es de tipo cortesía"
            ]);
            return;
        }

        if ($cortesia['estado'] !== 'activo') {
            echo json_encode([
                "status"  => "error",
                "message" => "La cortesía no está activa"
            ]);
            return;
        }

        if ((int)$cortesia['stockUsado'] > 0) {
            echo json_encode([
                "status"  => "error",
                "message" => "La cortesía ya fue utilizada y no puede reenviarse"
            ]);
            return;
        }
 
        $correoDestinatario = $cortesia['correoDestinatario'];
        $nombreDestinatario = $cortesia['nombreDestinatario'] ?? '';
        $codigoCupon        = $cortesia['codigoCupon'];
        $tituloEvento       = $cortesia['tituloEvento'] ?? 'tu evento';

        $asunto = "Cortesía para el evento: " . $tituloEvento;
        
        
        $nombreSafe = $nombreDestinatario
            ? htmlspecialchars($nombreDestinatario, ENT_QUOTES, 'UTF-8')
            : '';
        
        $tituloSafe = htmlspecialchars($tituloEvento, ENT_QUOTES, 'UTF-8');
        $codigoSafe = htmlspecialchars($codigoCupon, ENT_QUOTES, 'UTF-8');
        
        $saludo = $nombreSafe ? 'Hola ' . $nombreSafe . ',' : 'Hola,';
        
        // Solo 1 código en este flujo
        $itemsCupones = '<li style="margin-bottom:4px;"><strong>' . $codigoSafe . '</strong></li>';

        
            $mensajeHtml = '<!DOCTYPE html>
            <html lang="es">
            <head>
              <meta charset="UTF-8">
              <title>Entradas de cortesía para ' . $tituloSafe . '</title>
            </head>
            <body style="margin:0;padding:0;background-color:#050505;font-family:Arial,Helvetica,sans-serif;">
              <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="background-color:#050505;padding:20px 0;">
                <tr>
                  <td align="center">
                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="max-width:600px;background-color:#ffffff;border-radius:8px;overflow:hidden;">
                      <tr>
                        <td style="background-color:#000000;padding:20px 24px;text-align:center;">
                          <img src="https://www.ticketiza.cl/img/ICKETIZAMR(1).png" 
                               alt="Ticketiza" 
                               style="width:160px;max-width:70%;margin:0 auto;display:block;">
                          <p style="margin:8px 0 0;font-size:12px;color:#f4f4f5;">
                            Donde la noche se organiza ✨
                          </p>
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:24px 24px 8px;color:#111111;font-size:14px;line-height:1.6;">
                          <p style="margin:0 0 12px;">' . $saludo . '</p>
                          <p style="margin:0 0 12px;">
                            Te reenviamos tu entrada de <strong>cortesía</strong> para el evento 
                            <strong>' . $tituloSafe . '</strong> en Ticketiza.
                          </p>
                          <p style="margin:0 0 12px;">
                            Con este código puedes canjear tu entrada sin costo dentro del proceso de compra del evento.
                          </p>
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:8px 24px 8px;">
                          <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="background-color:#f9fafb;border-radius:6px;">
                            <tr>
                              <td style="padding:16px 18px;font-size:13px;color:#111111;line-height:1.5;">
                                <p style="margin:0 0 8px;font-weight:bold;font-size:13px;color:#000000;">
                                  Tu código de cortesía
                                </p>
                                <ul style="margin:0 0 0 18px;padding:0;list-style:disc;">
                                  ' . $itemsCupones . '
                                </ul>
                                <p style="margin:12px 0 0;font-size:12px;color:#4b5563;">
                                  Puedes usar este código según las condiciones del evento (por lo general, 1 entrada por código).
                                </p>
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:8px 24px 24px;font-size:11px;color:#6b7280;line-height:1.5;text-align:left;">
                          <p style="margin:0 0 8px;">
                            Para utilizar tu código, ingrésalo en el paso de pago del evento en Ticketiza.
                          </p>
                          <p style="margin:16px 0 0;color:#9ca3af;font-size:10px;">
                            Este correo fue enviado automáticamente desde Ticketiza. Si no estabas esperando esta cortesía, puedes ignorar este mensaje.
                          </p>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </body>
            </html>';



        $enviado = $this->enviarCorreoInterno(
            $asunto,
            $mensajeHtml,
            [$correoDestinatario]
        );

        if ($enviado && !empty($cortesia['idAsignacion'])) {
            // Reutilizamos la misma función que ya usabas
            $modeloCupon->marcarCortesiaEnviada((int)$cortesia['idAsignacion']);
        }

        if ($enviado) {
            echo json_encode([
                "status"  => "ok",
                "message" => "Cortesía reenviada correctamente"
            ]);
        } else {
            echo json_encode([
                "status"  => "error",
                "message" => "No se pudo enviar el correo de cortesía"
            ]);
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al reenviar cortesía: " . $e->getMessage()
        ]);
    }
}



public function listaDigitalEvento()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idEvento'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idEvento"
        ]);
        return;
    }

    $idEvento = (int)$data['idEvento'];

          require_once '../vendor/Fpdf/fpdf.php';

    try {
        $modelo = new EventoGestion();
        $asistentes = $modelo->obtenerAsistentesEvento($idEvento);

        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 10, 'Lista digital de asistentes - Evento ' . $idEvento, 0, 1, 'C');
        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(10, 7, '#', 1);
        $pdf->Cell(40, 7, 'Nombre', 1);
        $pdf->Cell(40, 7, 'Apellido', 1);
        $pdf->Cell(30, 7, 'RUT', 1);
        $pdf->Cell(40, 7, 'Correo', 1);
        $pdf->Cell(20, 7, 'Tickets', 1);
        $pdf->Ln();

        $pdf->SetFont('Arial', '', 8);
        $i = 1;
        foreach ($asistentes as $row) {
            $pdf->Cell(10, 6, $i++, 1);
            $pdf->Cell(40, 6, $row['nombre'], 1);
            $pdf->Cell(40, 6, $row['apellido'], 1);
            $pdf->Cell(30, 6, $row['rut'], 1);
            $pdf->Cell(40, 6, substr($row['correo'], 0, 30), 1);
            $pdf->Cell(20, 6, $row['cantidad'], 1);
            $pdf->Ln();
        }

        // Ruta donde se guardan listas digitales
        $basePath =self::PDF_BASE_DIR."/listas/";
        if (!is_dir($basePath)) {
            @mkdir($basePath, 0775, true);
        }

        $fileName = "lista_evento_" . $idEvento . ".pdf";
        $fullPath = $basePath . $fileName;

        $pdf->Output('F', $fullPath);

        $publicUrl = self::PDF_BASE_URL."/listas/" . $fileName;

        echo json_encode([
            "status"  => "ok",
            "message" => "Lista generada",
            "url"     => $publicUrl
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al generar lista digital: " . $e->getMessage()
        ]);
    }
}


public function dashboardProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idProductora"
        ]);
        return;
    }

    $idProductora = (int)$data['idProductora'];
    $desde        = $data['desde'] ?? null;
    $hasta        = $data['hasta'] ?? null;

    try {
        $modelo = new ReportesModel();
        $kpi = $modelo->kpiProductora($idProductora, $desde, $hasta);

        echo json_encode([
            "status" => "ok",
            "data"   => $kpi
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al obtener KPIs: " . $e->getMessage()
        ]);
    }
}


    public function dashboardUsuario()
    {
        $this->validateToken();
    
        $data = json_decode(file_get_contents("php://input"), true);
    
        if (empty($data['idUsuario'])) {
            http_response_code(400);
            echo json_encode([
                "status"  => "error",
                "message" => "Falta campo: idUsuario"
            ]);
            return;
        }
    
        $idUsuario = (int)$data['idUsuario'];
    
        try {
            
            $modelo = new PerfilInfoUsuario();
            $kpi = $modelo->kpisUsuario($idUsuario);
    
            echo json_encode([
                "status" => "ok",
                "data"   => $kpi
            ]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                "status"  => "error",
                "message" => "Error al obtener KPIs usuario: " . $e->getMessage()
            ]);
        }
    }




public function obtenerFinanzasProductora()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true) ?: [];

    $idProductora = (int)($data['idProductora'] ?? 0);
    $mes          = (int)($data['mes'] ?? 0);   // opcional
    $anio         = (int)($data['anio'] ?? 0);  // opcional

    if ($idProductora <= 0) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta parámetro idProductora"
        ]);
        return;
    }


    $m = new VentaFinanzasProductora();

    $res = $m->obtenerFinanzas($idProductora, $mes, $anio);

    if (empty($res['success'])) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => $res['error'] ?? 'No se pudieron obtener finanzas'
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "data"   => $res['data']
    ]);
}



public function informacionProductoraEventos()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idProductora"
        ]);
        return;
    }

    $idProductora = (int)$data['idProductora'];

    try {
        $modelo = new ReportesModel(); // o el modelo donde lo tengas
        $info = $modelo->informacionProductoraEventos($idProductora);

        echo json_encode([
            "status" => "ok",
            "data"   => $info
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al obtener información de la productora: " . $e->getMessage()
        ]);
    }
}


public function informesProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora']) || empty($data['tipo'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos: idProductora, tipo"
        ]);
        return;
    }

    $params = [
        'idProductora' => (int)$data['idProductora'],
        'tipo'         => $data['tipo'],
        'desde'        => $data['desde'] ?? null,
        'hasta'        => $data['hasta'] ?? null,
    ];

    try {
        $modelo = new ReportesModel();
        $rows = $modelo->informeProductora($params);

        echo json_encode([
            "status" => "ok",
            "data"   => $rows
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al obtener informe: " . $e->getMessage()
        ]);
    }
}


public function eliminarItemCarro()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    $idCarro   = isset($data['idcarro']) ? (int)$data['idcarro'] : 0;
    $idEvento  = isset($data['idEvento']) ? (int)$data['idEvento'] : 0;
    $idEntrada = isset($data['idEntradaEvento']) ? (int)$data['idEntradaEvento'] : 0;

    if (!$idCarro) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idcarro es requerido"
        ]);
        return;
    }

    if (!$idEvento) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEvento es requerido"
        ]);
        return;
    }

    if (!$idEntrada) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "idEntradaEvento es requerido"
        ]);
        return;
    }

    $carroModel = new CarroCompra();
    $ok = $carroModel->eliminarItem($idCarro, $idEvento, $idEntrada);

    echo json_encode([
        "status"  => $ok ? "ok" : "error",
        "removed" => $ok
    ]);
}


public function listarDescuentoProductora()
{
    $this->validateToken();
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['idProductora'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Falta campo: idProductora"
        ]);
        return;
    }

    $idProductora = (int)$data['idProductora'];

    try {
        $modelo = new CuponDescuentoModel(); 
        $descuentos = $modelo->listarDescuentoProductora($idProductora);

        echo json_encode([
            "status" => "ok",
            "data"   => $descuentos
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al listar descuentos: " . $e->getMessage()
        ]);
    }
}
public function obtenerInvitacionPorHash()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);
    if (!isset($data['hash'])) {
        http_response_code(400);
        echo json_encode([
            "error" => "El parámetro 'hash' es requerido"
        ]);
        exit();
    }

    $hash = $data['hash'];

    $init = new perfilesProductoras();
    $resp = $init->obtenerInvitacionPorHash($hash);

    if (!$resp) {
        echo json_encode([
            "status"  => "not_found",
            "message" => "Invitación no encontrada"
        ]);
        return;
    }

    echo json_encode([
        "status" => "ok",
        "message" => $resp
    ]);
}

  
  public function responderInvitacion()
{
    $this->validateToken(); // igual que los otros endpoints

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['hash']) || empty($data['accion'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan parámetros: hash y/o accion"
        ]);
        exit();
    }

    $hash         = $data['hash'];
    $accion       = $data['accion'];        // aceptar | rechazar
    $idUsuario    = isset($data['idUsuario'])    ? (int)$data['idUsuario']    : null;
    $correoSesion = isset($data['correoSesion']) ? trim($data['correoSesion']) : null;

    if (!$idUsuario || !$correoSesion) {
        echo json_encode([
            "status"  => "error",
            "message" => "Usuario no autenticado (faltan datos de sesión)."
        ]);
        return;
    }

    $init = new perfilesProductoras();
    $resp = $init->responderInvitacionPorHash($hash, $accion, $idUsuario, $correoSesion);

    echo json_encode($resp, JSON_UNESCAPED_UNICODE);
}


public function validarCuponCheckout()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['codigoCupon']) || empty($data['idEvento']) || empty($data['usuarioId'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos: codigoCupon, idEvento, usuarioId"
        ]);
        return;
    }

    $codigoCupon = trim($data['codigoCupon']);
    $idEvento    = (int)$data['idEvento'];
    $usuarioId   = (int)$data['usuarioId'];

    try {
        $modeloCupon = new CuponDescuentoModel();
        $resultado   = $modeloCupon->aplicarCuponEnCarro($codigoCupon, $idEvento, $usuarioId);

        if (!is_array($resultado) || ($resultado['status'] ?? '') !== 'ok') {
            echo json_encode([
                "status"  => "error",
                "message" => $resultado['message'] ?? 'No se pudo aplicar el cupón'
            ]);
            return;
        }

        echo json_encode($resultado);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al validar cupón: " . $e->getMessage()
        ]);
    }
}

public function canjearCortesiaEvento()
{
    $this->validateToken();

    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['codigoCupon']) || empty($data['idEvento']) || empty($data['usuarioId'])) {
        http_response_code(400);
        echo json_encode([
            "status"  => "error",
            "message" => "Faltan campos: codigoCupon, idEvento, usuarioId"
        ]);
        return;
    }

    $codigoCupon = trim($data['codigoCupon']);
    $idEvento    = (int)$data['idEvento'];
    $usuarioId   = (int)$data['usuarioId'];

    // cantidad opcional, por defecto 1
    $cantidad = isset($data['cantidad']) ? (int)$data['cantidad'] : 1;
    if ($cantidad <= 0) $cantidad = 1;

    try {
        $modeloCupon = new CuponDescuentoModel();

        // Nuevo método: agrega al carro si no existe y aplica cortesía
        $resultado = $modeloCupon->canjearCortesiaEnCarro($codigoCupon, $idEvento, $usuarioId, $cantidad);

        if (!is_array($resultado) || ($resultado['status'] ?? '') !== 'ok') {
            echo json_encode([
                "status"  => "error",
                "message" => $resultado['message'] ?? 'No se pudo canjear la cortesía'
            ]);
            return;
        }

        echo json_encode($resultado);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status"  => "error",
            "message" => "Error al canjear cortesía: " . $e->getMessage()
        ]);
    }
}


public function resumenTicketsEvento()
{
    $this->validateToken();

    $body = json_decode(file_get_contents('php://input'), true) ?? [];
    $idEvento = $_GET['idEvento'] ?? ($body['idEvento'] ?? null);
    $idEvento = ($idEvento !== null && $idEvento !== '' && $idEvento !== 'null')
        ? (int)$idEvento
        : null;

    if ($idEvento === null) {
        echo json_encode([
            "message" => "idEvento es obligatorio",
            "status"  => "error"
        ]);
        return;
    }

    $init    = new Evento();
    $mensaje = $init->resumenTicketsEvento($idEvento);

    if ($mensaje === false) {
        echo json_encode([
            "message" => "Hay un error en el sistema",
            "status"  => "error"
        ]);
        return;
    }

    echo json_encode([
        "message" => $mensaje,
        "status"  => "ok"
    ]);
}




public function listarRegionesChile()
{
    $this->validateToken();

    $model = new Direcciones();
    $data = $model->listarRegiones();

    if ($data === false) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "No se pudieron obtener regiones"]);
        return;
    }

    echo json_encode(["status" => "ok", "data" => $data], JSON_UNESCAPED_UNICODE);
}

    public function listarCiudadesPorRegion()
    {
        $this->validateToken();
    
        $idRegion = isset($_GET['idRegion']) ? (int)$_GET['idRegion'] : 0;
    
        if ($idRegion <= 0) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "idRegion es requerido"
            ]);
            return;
        }
    
        $model = new Direcciones();
        $data = $model->listarCiudadesPorRegion($idRegion);
    
        if ($data === false) {
            http_response_code(500);
            echo json_encode([
                "status" => "error",
                "message" => "No se pudieron obtener ciudades"
            ]);
            return;
        }
    
        echo json_encode([
            "status" => "ok",
            "data" => $data
        ], JSON_UNESCAPED_UNICODE);
    }

    
    public function listarComunasPorCiudad()
    {
        $this->validateToken();
    
        $idCiudad = isset($_GET['idCiudad']) ? (int)$_GET['idCiudad'] : 0;
    
        if ($idCiudad <= 0) {
            http_response_code(400);
            echo json_encode([
                "status" => "error",
                "message" => "idCiudad es requerido"
            ]);
            return;
        }
    
        $model = new Direcciones();
        $data = $model->listarComunasPorCiudad($idCiudad);
    
        if ($data === false) {
            http_response_code(500);
            echo json_encode([
                "status" => "error",
                "message" => "No se pudieron obtener comunas"
            ]);
            return;
        }
    
        echo json_encode([
            "status" => "ok",
            "data" => $data
        ], JSON_UNESCAPED_UNICODE);
    }

    
    public function obtenerRutaDireccionPorComuna()
    {
        $this->validateToken();
    
        $body = json_decode(file_get_contents("php://input"), true) ?? [];
        $idComuna = isset($body['idComuna']) ? (int)$body['idComuna'] : 0;
    
        if ($idComuna <= 0) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "idComuna es requerido"]);
            return;
        }
    
        $model = new Direcciones();
        $data = $model->obtenerRutaPorComuna($idComuna);
    
        echo json_encode([
            "status" => "ok",
            "data"   => $data ?: null
        ], JSON_UNESCAPED_UNICODE);
    }



public function resumenConsumosEvento()
{
    $this->validateToken();

    $body = json_decode(file_get_contents('php://input'), true) ?? [];
    $idEvento = $_GET['idEvento'] ?? ($body['idEvento'] ?? null);
    $idEvento = ($idEvento !== null && $idEvento !== '' && $idEvento !== 'null')
        ? (int)$idEvento
        : null;

    if ($idEvento === null) {
        echo json_encode([
            "message" => "idEvento es obligatorio",
            "status"  => "error"
        ]);
        return;
    }

    $init    = new Evento();
    $mensaje = $init->resumenConsumosEvento($idEvento);

    if ($mensaje === false) {
        echo json_encode([
            "message" => "Hay un error en el sistema",
            "status"  => "error"
        ]);
        return;
    }

    echo json_encode([
        "message" => $mensaje,
        "status"  => "ok"
    ]);
}


    public function enviarWhatsapp()
    {
        $this->validateToken();
    
        try {
            $data = json_decode(file_get_contents("php://input"), true);
    
            if (
                empty($data['idProductora']) ||
                empty($data['numero']) ||
                empty($data['mensaje'])
            ) {
                http_response_code(400);
                echo json_encode([
                    'status'  => 'error',
                    'message' => 'Parámetros incompletos'
                ]);
                return;
            }
    
            $productId = 'fe70723e-e86a-446a-a283-afd7d070b614';
            $phoneId   = '126163';
            $token     = '6e893784-1b2b-4660-8b61-0c09f89bce51';
    
            $modelo = new WhatsappModel();
    
            $resp = $modelo->enviarMensaje(
                (int) $data['idProductora'],
                $productId,
                $phoneId,
                $token,
                $data['numero'],
                $data['mensaje'],
                null
            );
    
            echo json_encode([
                'status' => 'ok',
                'data'   => $resp
            ]);
    
        } catch (\Throwable $e) {
            http_response_code(500);
            echo json_encode([
                'status'  => 'error',
                'message' => 'Error interno en enviarWhatsapp',
                'detail'  => $e->getMessage()
            ]);
        }
}


    
    
    public function webhookMaytapi()
        {
            $payload = json_decode(file_get_contents('php://input'), true);
        
            if (!$payload) {
                http_response_code(400);
                echo json_encode(['status' => 'error', 'message' => 'Payload vacío']);
                return;
            }
        
            file_put_contents(
                __DIR__ . '/../../logs/maytapi.log',
                date('Y-m-d H:i:s') . ' ' . json_encode($payload) . PHP_EOL,
                FILE_APPEND
            );
        
            echo json_encode(['status' => 'ok']);
        }

 
public function ciProductosPorEvento()
{
    $this->validateToken();

    header('Content-Type: application/json; charset=utf-8');

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"JSON inválido"]);
        exit();
    }

    if (empty($data['idEvento'])) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"El parámetro 'idEvento' es requerido"]);
        exit();
    }

    $idEvento = (int)$data['idEvento'];
    if ($idEvento <= 0) {
        http_response_code(400);
        echo json_encode(["status"=>"error","message"=>"idEvento inválido"]);
        exit();
    }

    $idCategoria = 0;
    if (isset($data['idCategoria']) && $data['idCategoria'] !== '' && $data['idCategoria'] !== null) {
        $idCategoria = (int)$data['idCategoria'];
        if ($idCategoria < 0) $idCategoria = 0;
    }

    $init = new ComprasInternas();
    $productos = $init->ciProductosPorEvento($idEvento, $idCategoria);

    echo json_encode([
        "status"  => "ok",
        "message" => $productos
    ], JSON_UNESCAPED_UNICODE);
    exit();
}



}
